/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.evosuite.runtime.classhandling.ModifiedTargetStaticFields;
import org.evosuite.runtime.instrumentation.CreateClassResetMethodAdapter;
import org.evosuite.runtime.instrumentation.MethodCallReplacementClassAdapter;
import org.evosuite.runtime.instrumentation.MultiMethodVisitor;
import org.evosuite.runtime.instrumentation.RemoveFinalMethodAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateClassResetClassAdapter
extends ClassVisitor {
    private final boolean removeFinalModifierOnStaticFields;
    private boolean removeUpdatesOnFinalFields = true;
    private final String className;
    public static List<String> staticClasses = new ArrayList<String>();
    private static Logger logger = LoggerFactory.getLogger(CreateClassResetClassAdapter.class);
    private boolean isInterface = false;
    private boolean isAnonymous = false;
    private boolean clinitFound = false;
    private boolean definesUid = false;
    private long serialUID = -1L;
    private boolean resetMethodAdded = false;
    private final List<String> finalFields = new ArrayList<String>();
    private boolean isEnum = false;
    private static final Pattern ANONYMOUS_MATCHER1 = Pattern.compile(".*\\$\\d+.*$");
    private final List<StaticField> static_fields = new LinkedList<StaticField>();
    private final ArrayList<String> modifiedStaticFields = new ArrayList();

    public void setRemoveUpdatesOnFinalFields(boolean removeUpdatesOnFinalFields) {
        this.removeUpdatesOnFinalFields = removeUpdatesOnFinalFields;
    }

    public CreateClassResetClassAdapter(ClassVisitor visitor, String className, boolean removeFinalModifierOnStaticFields) {
        super(327680, visitor);
        this.className = className;
        this.removeFinalModifierOnStaticFields = removeFinalModifierOnStaticFields;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        boolean bl = this.isInterface = (access & 0x200) == 512;
        if (ANONYMOUS_MATCHER1.matcher(name).matches()) {
            this.isAnonymous = true;
        }
        if (superName.equals(Enum.class.getName().replace(".", "/"))) {
            this.isEnum = true;
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals("serialVersionUID")) {
            this.definesUid = true;
            return super.visitField(access, name, desc, signature, value);
        }
        if (this.hasStaticModifier(access)) {
            StaticField staticField = new StaticField();
            staticField.name = name;
            staticField.desc = desc;
            staticField.value = value;
            this.static_fields.add(staticField);
        }
        if (!this.isEnum && !this.isInterface && this.removeFinalModifierOnStaticFields) {
            int newAccess = access & 0xFFFFFFEF;
            if (newAccess != access) {
                this.modifiedStaticFields.add(name);
            }
            return super.visitField(newAccess, name, desc, signature, value);
        }
        if (this.hasFinalModifier(access)) {
            this.finalFields.add(name);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    private boolean hasFinalModifier(int access) {
        return (access & 0x10) == 16;
    }

    private boolean hasStaticModifier(int access) {
        return (access & 8) == 8;
    }

    public MethodVisitor visitMethod(int methodAccess, String methodName, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, methodName, descriptor, signature, exceptions);
        if (methodName.equals("<clinit>") && !this.isInterface && !this.isAnonymous && !this.resetMethodAdded) {
            this.clinitFound = true;
            logger.info("Found static initializer in class " + this.className);
            MethodVisitor visitMethod = super.visitMethod(methodAccess | 8 | 0x1000, "__STATIC_RESET", descriptor, signature, exceptions);
            CreateClassResetMethodAdapter staticResetMethodAdapter = new CreateClassResetMethodAdapter(visitMethod, this.className, this.static_fields, this.finalFields);
            this.resetMethodAdded = true;
            if (this.removeUpdatesOnFinalFields) {
                RemoveFinalMethodAdapter mv2 = new RemoveFinalMethodAdapter(this.className, staticResetMethodAdapter, this.finalFields);
                return new MultiMethodVisitor(mv2, mv);
            }
            return new MultiMethodVisitor(staticResetMethodAdapter, mv);
        }
        if (methodName.equals("__STATIC_RESET") && !this.resetMethodAdded) {
            this.resetMethodAdded = true;
        }
        return mv;
    }

    public void visitEnd() {
        if (!(this.clinitFound || this.isInterface || this.isAnonymous || this.resetMethodAdded)) {
            if (!this.definesUid) {
                // empty if block
            }
            this.createEmptyStaticReset();
        } else if (!this.clinitFound || !this.definesUid) {
            // empty if block
        }
        if (!this.modifiedStaticFields.isEmpty()) {
            ModifiedTargetStaticFields.getInstance().addFinalFields(this.modifiedStaticFields);
        }
        super.visitEnd();
    }

    @Deprecated
    private void determineSerialisableUID() {
        try {
            Class<?> clazz = Class.forName(this.className.replace('/', '.'), false, MethodCallReplacementClassAdapter.class.getClassLoader());
            if (Serializable.class.isAssignableFrom(clazz)) {
                ObjectStreamClass c = ObjectStreamClass.lookup(clazz);
                this.serialUID = c.getSerialVersionUID();
            }
        }
        catch (ClassNotFoundException e) {
            logger.info("Failed to add serialId to class " + this.className + ": " + e.getMessage());
        }
    }

    @Deprecated
    private void createSerialisableUID() {
        if (this.serialUID < 0L) {
            return;
        }
        logger.info("Adding serialId to class " + this.className);
        this.visitField(26, "serialVersionUID", "J", null, this.serialUID);
    }

    private void createEmptyStaticReset() {
        logger.info("Creating brand-new static initializer in class " + this.className);
        MethodVisitor mv = this.cv.visitMethod(4105, "__STATIC_RESET", "()V", null, null);
        mv.visitCode();
        for (StaticField staticField : this.static_fields) {
            if (this.finalFields.contains(staticField.name) || staticField.name.startsWith("__cobertura") || staticField.name.startsWith("$jacoco") || staticField.name.startsWith("$VRc")) continue;
            logger.info("Adding bytecode for initializing field " + staticField.name);
            if (staticField.value != null) {
                mv.visitLdcInsn(staticField.value);
            } else {
                Type type = Type.getType((String)staticField.desc);
                switch (type.getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        mv.visitInsn(3);
                        break;
                    }
                    case 6: {
                        mv.visitInsn(11);
                        break;
                    }
                    case 7: {
                        mv.visitInsn(9);
                        break;
                    }
                    case 8: {
                        mv.visitInsn(14);
                        break;
                    }
                    case 9: 
                    case 10: {
                        mv.visitInsn(1);
                    }
                }
            }
            mv.visitFieldInsn(179, this.className, staticField.name, staticField.desc);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    static class StaticField {
        String name;
        String desc;
        Object value;

        StaticField() {
        }

        public String toString() {
            return "StaticField [name=" + this.name + "]";
        }
    }
}

