/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.evosuite.PackageInfo;
import org.evosuite.runtime.instrumentation.RuntimeInstrumentation;

public class ExcludedClasses {
    private static boolean classesLoaded = false;
    public static List<String> excludedClasses = new ArrayList<String>();

    private static void loadExcludedClassNames() {
        if (classesLoaded) {
            return;
        }
        InputStream excludedClassesStream = ExcludedClasses.class.getClassLoader().getResourceAsStream("excluded.classes");
        classesLoaded = true;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(excludedClassesStream));
            String line = null;
            while ((line = br.readLine()) != null) {
                excludedClasses.add(line);
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static List<String> getPackagesShouldNotBeInstrumented() {
        ArrayList<String> list = new ArrayList<String>();
        ExcludedClasses.loadExcludedClassNames();
        list.add(PackageInfo.getEvoSuitePackage());
        list.addAll(excludedClasses);
        if (RuntimeInstrumentation.getAvoidInstrumentingShadedClasses()) {
            list.addAll(Arrays.asList("org.hibernate.", "org.hsqldb.", "org.jboss.", "org.springframework.", "org.apache.commons.logging.", "javassist.", "antlr.", "org.dom4j.", "org.aopalliance.", "javax.servlet.", "org.mockito.", "org.apache", "org.hamcrest", "org.objenesis"));
        }
        return list;
    }
}

