/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.evosuite.runtime.instrumentation.AnnotatedLabel;
import org.evosuite.runtime.instrumentation.MethodCallReplacementMethodAdapter;
import org.evosuite.runtime.mock.InvokeSpecialMock;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.MockList;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodCallReplacement {
    private final String className;
    private final String methodName;
    private final String desc;
    private final int origOpcode;
    private final String replacementClassName;
    private final String replacementMethodName;
    private final String replacementDesc;
    private final boolean popCallee;
    private final boolean popUninitialisedReference;
    private static final Logger logger = LoggerFactory.getLogger(MethodCallReplacement.class);

    public MethodCallReplacement(String className, String methodName, String desc, int opcode, String replacementClassName, String replacementMethodName, String replacementDesc, boolean pop, boolean pop2) {
        this.className = className;
        this.methodName = methodName;
        this.desc = desc;
        this.replacementClassName = replacementClassName;
        this.replacementMethodName = replacementMethodName;
        this.replacementDesc = replacementDesc;
        this.popCallee = pop;
        this.popUninitialisedReference = pop2;
        this.origOpcode = opcode;
    }

    public boolean isTarget(String owner, String name, String desc) {
        return this.className.equals(owner) && this.methodName.equals(name) && this.desc.equals(desc);
    }

    public void insertMethodCall(MethodCallReplacementMethodAdapter mv, int opcode) {
        mv.visitMethodInsn(184, MockFramework.class.getCanonicalName().replace('.', '/'), "isEnabled", "()Z", false);
        Label origCallLabel = new Label();
        Label afterOrigCallLabel = new Label();
        AnnotatedLabel annotationStartTag = new AnnotatedLabel(true, true);
        annotationStartTag.info = Boolean.TRUE;
        mv.visitLabel(annotationStartTag);
        mv.visitJumpInsn(153, origCallLabel);
        AnnotatedLabel annotationEndTag = new AnnotatedLabel(true, false);
        annotationEndTag.info = Boolean.FALSE;
        mv.visitLabel(annotationEndTag);
        if (this.popCallee) {
            int i;
            Type[] args = Type.getArgumentTypes((String)this.desc);
            HashMap<Integer, Integer> to = new HashMap<Integer, Integer>();
            for (i = args.length - 1; i >= 0; --i) {
                int loc = mv.newLocal(args[i]);
                mv.storeLocal(loc);
                to.put(i, loc);
            }
            mv.pop();
            if (this.popUninitialisedReference) {
                mv.pop();
            }
            for (i = 0; i < args.length; ++i) {
                mv.loadLocal((Integer)to.get(i));
            }
        }
        if (opcode == 183 && MockList.shouldBeMocked(this.className.replace('/', '.'))) {
            this.insertInvokeSpecialForMockedSuperclass(mv);
        } else {
            if (opcode == 183) {
                logger.info("Not mocking invokespecial: " + this.replacementMethodName + " for class " + this.className);
            }
            mv.visitMethodInsn(opcode, this.replacementClassName, this.replacementMethodName, this.replacementDesc, false);
        }
        mv.visitJumpInsn(167, afterOrigCallLabel);
        mv.visitLabel(origCallLabel);
        mv.getNextVisitor().visitMethodInsn(this.origOpcode, this.className, this.methodName, this.desc, false);
        mv.visitLabel(afterOrigCallLabel);
    }

    public void insertInvokeSpecialForMockedSuperclass(MethodCallReplacementMethodAdapter mv) {
        int numArguments = Type.getArgumentTypes((String)this.replacementDesc).length;
        mv.push(numArguments);
        mv.newArray(Type.getType(Object.class));
        for (int i = 0; i < numArguments; ++i) {
            mv.dupX1();
            mv.swap();
            mv.push(numArguments - i - 1);
            mv.swap();
            mv.arrayStore(Type.getType(Object.class));
        }
        mv.push(this.methodName);
        mv.push(this.desc);
        Method invokeSpecialMethod = InvokeSpecialMock.class.getDeclaredMethods()[0];
        mv.visitMethodInsn(184, InvokeSpecialMock.class.getCanonicalName().replace('.', '/'), "invokeSpecial", Type.getMethodDescriptor((Method)invokeSpecialMethod), false);
        if (Type.getReturnType((String)this.desc).equals((Object)Type.VOID_TYPE)) {
            mv.pop();
        } else {
            mv.visitTypeInsn(192, Type.getReturnType((String)this.desc).getInternalName());
        }
    }

    public void insertConstructorCall(MethodCallReplacementMethodAdapter mv, MethodCallReplacement replacement, boolean isSelf) {
        Label origCallLabel = new Label();
        Label afterOrigCallLabel = new Label();
        if (!isSelf) {
            int i;
            mv.visitMethodInsn(184, MockFramework.class.getCanonicalName().replace('.', '/'), "isEnabled", "()Z", false);
            AnnotatedLabel annotationStartTag = new AnnotatedLabel(true, true);
            annotationStartTag.info = Boolean.TRUE;
            mv.visitLabel(annotationStartTag);
            mv.visitJumpInsn(153, origCallLabel);
            AnnotatedLabel annotationEndTag = new AnnotatedLabel(true, false);
            annotationEndTag.info = Boolean.FALSE;
            mv.visitLabel(annotationEndTag);
            Type[] args = Type.getArgumentTypes((String)this.desc);
            HashMap<Integer, Integer> to = new HashMap<Integer, Integer>();
            for (i = args.length - 1; i >= 0; --i) {
                int loc = mv.newLocal(args[i]);
                mv.storeLocal(loc);
                to.put(i, loc);
            }
            mv.pop2();
            mv.newInstance(Type.getType((String)replacement.replacementClassName));
            mv.dup();
            for (i = 0; i < args.length; ++i) {
                mv.loadLocal((Integer)to.get(i));
            }
        }
        mv.visitMethodInsn(183, this.replacementClassName, this.replacementMethodName, this.replacementDesc, false);
        if (!isSelf) {
            mv.visitJumpInsn(167, afterOrigCallLabel);
            mv.visitLabel(origCallLabel);
            mv.getNextVisitor().visitMethodInsn(183, this.className, this.methodName, this.desc, false);
            mv.visitLabel(afterOrigCallLabel);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodNameWithDesc() {
        return this.methodName + this.desc;
    }
}

