/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.PackageInfo;
import org.evosuite.runtime.Random;
import org.evosuite.runtime.Reflection;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.System;
import org.evosuite.runtime.instrumentation.MethodCallReplacement;
import org.evosuite.runtime.mock.EvoSuiteMock;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.StaticReplacementMethod;
import org.evosuite.runtime.mock.StaticReplacementMock;
import org.evosuite.runtime.mock.java.lang.MockThrowable;
import org.evosuite.runtime.mock.javax.swing.MockJComponent;
import org.evosuite.runtime.util.ReflectionUtils;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodCallReplacementCache {
    private static final Logger logger = LoggerFactory.getLogger(MethodCallReplacementCache.class);
    private static MethodCallReplacementCache instance = null;
    private final Map<String, Map<String, MethodCallReplacement>> replacementCalls = new HashMap<String, Map<String, MethodCallReplacement>>();
    private final Map<String, Map<String, MethodCallReplacement>> specialReplacementCalls = new HashMap<String, Map<String, MethodCallReplacement>>();

    private MethodCallReplacementCache() {
        if (RuntimeSettings.mockJVMNonDeterminism) {
            this.addJavaLangCalls();
            this.addReplacementCall(new MethodCallReplacement("javax/swing/JComponent", "getPreferredSize", "()Ljava/awt/Dimension;", 182, PackageInfo.getNameWithSlash(MockJComponent.class), "getPreferredSize", "()Ljava/awt/Dimension;", true, false));
            this.addExtraceExceptionReplacements();
        }
        this.handleMockList();
    }

    public static MethodCallReplacementCache getInstance() {
        if (instance == null) {
            instance = new MethodCallReplacementCache();
        }
        return instance;
    }

    public static void resetSingleton() {
        instance = null;
    }

    private void addReplacementCall(MethodCallReplacement replacement) {
        if (!this.replacementCalls.containsKey(replacement.getClassName())) {
            this.replacementCalls.put(replacement.getClassName(), new HashMap());
        }
        this.replacementCalls.get(replacement.getClassName()).put(replacement.getMethodNameWithDesc(), replacement);
    }

    private void addSpecialReplacementCall(MethodCallReplacement replacement) {
        if (!this.specialReplacementCalls.containsKey(replacement.getClassName())) {
            this.specialReplacementCalls.put(replacement.getClassName(), new HashMap());
        }
        this.specialReplacementCalls.get(replacement.getClassName()).put(replacement.getMethodNameWithDesc(), replacement);
    }

    public boolean hasReplacementCall(String className, String methodNameWithDesc) {
        if (!this.replacementCalls.containsKey(className)) {
            return false;
        }
        return this.replacementCalls.get(className).containsKey(methodNameWithDesc);
    }

    public MethodCallReplacement getReplacementCall(String className, String methodNameWithDesc) {
        return this.replacementCalls.get(className).get(methodNameWithDesc);
    }

    public boolean hasSpecialReplacementCall(String className, String methodNameWithDesc) {
        if (!this.specialReplacementCalls.containsKey(className)) {
            return false;
        }
        return this.specialReplacementCalls.get(className).containsKey(methodNameWithDesc);
    }

    public MethodCallReplacement getSpecialReplacementCall(String className, String methodNameWithDesc) {
        return this.specialReplacementCalls.get(className).get(methodNameWithDesc);
    }

    private void addExtraceExceptionReplacements() {
        List<Class> classes = Arrays.asList(IOException.class, Throwable.class, ArithmeticException.class, ArrayIndexOutOfBoundsException.class, ArrayStoreException.class, ClassCastException.class, ClassNotFoundException.class, CloneNotSupportedException.class, EnumConstantNotPresentException.class, Exception.class, IllegalAccessException.class, IllegalArgumentException.class, IllegalMonitorStateException.class, IllegalStateException.class, IllegalThreadStateException.class, IndexOutOfBoundsException.class, InstantiationException.class, InterruptedException.class, NegativeArraySizeException.class, NoSuchFieldException.class, NoSuchMethodException.class, NullPointerException.class, NumberFormatException.class, ReflectiveOperationException.class, RuntimeException.class, SecurityException.class, StringIndexOutOfBoundsException.class, TypeNotPresentException.class, UnsupportedOperationException.class, AbstractMethodError.class, AssertionError.class, BootstrapMethodError.class, ClassCircularityError.class, ClassFormatError.class, Error.class, ExceptionInInitializerError.class, IllegalAccessError.class, IncompatibleClassChangeError.class, InstantiationError.class, InternalError.class, LinkageError.class, NoClassDefFoundError.class, NoSuchFieldError.class, NoSuchMethodError.class, OutOfMemoryError.class, StackOverflowError.class, ThreadDeath.class, UnknownError.class, UnsatisfiedLinkError.class, UnsupportedClassVersionError.class, VerifyError.class, VirtualMachineError.class);
        for (Class k : classes) {
            String jvmOriginal = k.getName().replace('.', '/');
            String jvmMock = MockThrowable.class.getName().replace('.', '/');
            this.addReplacementCall(new MethodCallReplacement(jvmOriginal, "getStackTrace", "()[Ljava/lang/StackTraceElement;", 182, jvmMock, "replacement_getStackTrace", "(Ljava/lang/Throwable;)[Ljava/lang/StackTraceElement;", false, false));
            this.addReplacementCall(new MethodCallReplacement(jvmOriginal, "printStackTrace", "(Ljava/io/PrintStream;)V", 182, jvmMock, "replacement_printStackTrace", "(Ljava/lang/Throwable;Ljava/io/PrintStream;)V", false, false));
            this.addReplacementCall(new MethodCallReplacement(jvmOriginal, "printStackTrace", "(Ljava/io/PrintWriter;)V", 182, jvmMock, "replacement_printStackTrace", "(Ljava/lang/Throwable;Ljava/io/PrintWriter;)V", false, false));
        }
    }

    private void handleMockList() {
        for (Class<? extends EvoSuiteMock> mock : MockList.getList()) {
            Class<?> mocked;
            String mockedName;
            if (OverrideMock.class.isAssignableFrom(mock)) {
                this.replaceAllConstructors(mock, mock.getSuperclass());
                this.replaceAllStaticMethods(mock, mock.getSuperclass());
                this.replaceAllInvokeSpecial(mock, mock.getSuperclass());
                this.handleStaticReplacementMethods(mock);
                continue;
            }
            if (!StaticReplacementMock.class.isAssignableFrom(mock)) continue;
            try {
                mockedName = ((StaticReplacementMock)mock.newInstance()).getMockedClassName();
            }
            catch (IllegalAccessException | InstantiationException e1) {
                logger.error("Cannot instantiate mock " + mock.getCanonicalName());
                continue;
            }
            try {
                mocked = StaticReplacementMock.class.getClassLoader().loadClass(mockedName);
            }
            catch (ClassNotFoundException e) {
                logger.error("Mock class " + mock.getCanonicalName() + " has non-existent mocked target " + mockedName);
                continue;
            }
            this.replaceAllStaticMethods(mock, mocked);
            this.replaceAllInstanceMethodsWithStatic(mock, mocked);
            this.replaceAllConstructorsWithStaticCalls(mock, mocked);
        }
    }

    private void handleStaticReplacementMethods(Class<? extends EvoSuiteMock> mockClass) {
        for (Method m : mockClass.getMethods()) {
            StaticReplacementMethod srm = m.getAnnotation(StaticReplacementMethod.class);
            if (srm == null) continue;
            if (!Modifier.isStatic(m.getModifiers())) {
                throw new RuntimeException("EvoSuite Bug: improper annotations in class " + mockClass.getName());
            }
            if (!OverrideMock.class.isAssignableFrom(mockClass)) {
                throw new RuntimeException("EvoSuite Bug: StaticReplacementMethod can only be used in OverrideMock");
            }
            String target = mockClass.getSuperclass().getCanonicalName();
            String desc = Type.getMethodDescriptor((Method)m);
            this.addSpecialReplacementCall(new MethodCallReplacement(target.replace('.', '/'), m.getName(), desc, 183, mockClass.getCanonicalName().replace('.', '/'), m.getName(), desc, false, false));
        }
    }

    private void addJavaLangCalls() {
        this.addReplacementCall(new MethodCallReplacement("java/lang/System", "exit", "(I)V", 184, PackageInfo.getNameWithSlash(System.class), "exit", "(I)V", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/System", "setSecurityManager", "(Ljava/lang/SecurityManager;)V", 184, PackageInfo.getNameWithSlash(System.class), "setSecurityManager", "(Ljava/lang/SecurityManager;)V", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/System", "currentTimeMillis", "()J", 184, PackageInfo.getNameWithSlash(System.class), "currentTimeMillis", "()J", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/System", "nanoTime", "()J", 184, PackageInfo.getNameWithSlash(System.class), "nanoTime", "()J", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/System", "identityHashCode", "(Ljava/lang/Object;)I", 184, "org/evosuite/runtime/System", "identityHashCode", "(Ljava/lang/Object;)I", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Object", "hashCode", "()I", 182, PackageInfo.getNameWithSlash(System.class), "identityHashCode", "(Ljava/lang/Object;)I", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Object", "toString", "()Ljava/lang/String;", 182, PackageInfo.getNameWithSlash(System.class), "toString", "(Ljava/lang/Object;)Ljava/lang/String;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Math", "random", "()D", 184, PackageInfo.getNameWithSlash(Random.class), "nextDouble", "()D", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getClasses", "()[Ljava/lang/Class;", 182, PackageInfo.getNameWithSlash(Reflection.class), "getClasses", "(Ljava/lang/Class;)[Ljava/lang/Class;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getAnnotations", "()[Ljava/lang/annotation/Annotation;", 182, PackageInfo.getNameWithSlash(Reflection.class), "getAnnotations", "(Ljava/lang/Class;)[Ljava/lang/annotation/Annotation;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getFields", "()[Ljava/lang/reflect/Field;", 182, PackageInfo.getNameWithSlash(Reflection.class), "getFields", "(Ljava/lang/Class;)[Ljava/lang/reflect/Field;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getConstructors", "()[Ljava/lang/reflect/Constructor;", 182, PackageInfo.getNameWithSlash(Reflection.class), "getConstructors", "(Ljava/lang/Class;)[Ljava/lang/reflect/Constructor;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;", 182, PackageInfo.getNameWithSlash(Reflection.class), "getMethods", "(Ljava/lang/Class;)[Ljava/lang/reflect/Method;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getDeclaredClasses", "()[Ljava/lang/Class;", 182, PackageInfo.getNameWithSlash(Reflection.class), "getDeclaredClasses", "(Ljava/lang/Class;)[Ljava/lang/Class;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getDeclaredAnnotations", "()[Ljava/lang/annotation/Annotation;", 182, PackageInfo.getNameWithSlash(Reflection.class), "getDeclaredAnnotations", "(Ljava/lang/Class;)[Ljava/lang/annotation/Annotation;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getDeclaredFields", "()[Ljava/lang/reflect/Field;", 182, PackageInfo.getNameWithSlash(Reflection.class), "getDeclaredFields", "(Ljava/lang/Class;)[Ljava/lang/reflect/Field;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;", 182, PackageInfo.getNameWithSlash(Reflection.class), "getDeclaredConstructors", "(Ljava/lang/Class;)[Ljava/lang/reflect/Constructor;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getDeclaredMethods", "()[Ljava/lang/reflect/Method;", 182, PackageInfo.getNameWithSlash(Reflection.class), "getDeclaredMethods", "(Ljava/lang/Class;)[Ljava/lang/reflect/Method;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getInterfaces", "()[Ljava/lang/Class;", 182, PackageInfo.getNameWithSlash(Reflection.class), "getInterfaces", "(Ljava/lang/Class;)[Ljava/lang/Class;", false, false));
        this.addReplacementCall(new MethodCallReplacement("java/lang/Class", "getModifiers", "()I", 182, PackageInfo.getNameWithSlash(Reflection.class), "getModifiers", "(Ljava/lang/Class;)I", false, false));
    }

    private void replaceAllInstanceMethodsWithStatic(Class<?> mockClass, Class<?> target) {
        for (Method m : ReflectionUtils.getMethods(target)) {
            if (Modifier.isStatic(m.getModifiers())) continue;
            Class[] parameters = new Class[m.getParameterCount() + 1];
            parameters[0] = target;
            int numParam = 1;
            for (Class<?> paramClass : m.getParameterTypes()) {
                parameters[numParam++] = paramClass;
            }
            try {
                mockClass.getMethod(m.getName(), parameters);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            String desc = Type.getMethodDescriptor((Method)m);
            Type[] argumentTypes = Type.getArgumentTypes((Method)m);
            Type[] mockedArgumentTypes = new Type[argumentTypes.length + 1];
            mockedArgumentTypes[0] = Type.getType(target);
            for (int i = 0; i < argumentTypes.length; ++i) {
                mockedArgumentTypes[i + 1] = argumentTypes[i];
            }
            String mockedDesc = Type.getMethodDescriptor((Type)Type.getReturnType((Method)m), (Type[])mockedArgumentTypes);
            this.addReplacementCall(new MethodCallReplacement(target.getCanonicalName().replace('.', '/'), m.getName(), desc, 182, mockClass.getCanonicalName().replace('.', '/'), m.getName(), mockedDesc, false, false));
        }
    }

    private void replaceAllStaticMethods(Class<?> mockClass, Class<?> target) throws IllegalArgumentException {
        for (Method m : target.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers())) continue;
            String desc = Type.getMethodDescriptor((Method)m);
            this.addReplacementCall(new MethodCallReplacement(target.getCanonicalName().replace('.', '/'), m.getName(), desc, 184, mockClass.getCanonicalName().replace('.', '/'), m.getName(), desc, false, false));
        }
    }

    private void replaceAllConstructors(Class<?> mockClass, Class<?> target) throws IllegalArgumentException {
        if (!target.isAssignableFrom(mockClass)) {
            throw new IllegalArgumentException("Constructor replacement can be done only for subclasses. Class " + mockClass + " is not an instance of " + target);
        }
        for (Constructor<?> constructor : ReflectionUtils.getDeclaredConstructors(mockClass)) {
            String desc = Type.getConstructorDescriptor(constructor);
            this.addSpecialReplacementCall(new MethodCallReplacement(target.getCanonicalName().replace('.', '/'), "<init>", desc, 183, mockClass.getCanonicalName().replace('.', '/'), "<init>", desc, false, false));
        }
    }

    private void replaceAllConstructorsWithStaticCalls(Class<?> mockClass, Class<?> target) throws IllegalArgumentException {
        for (Constructor<?> constructor : target.getConstructors()) {
            String desc = Type.getConstructorDescriptor(constructor);
            String replacementDesc = desc.substring(0, desc.length() - 1) + Type.getDescriptor(target);
            this.addReplacementCall(new MethodCallReplacement(target.getCanonicalName().replace('.', '/'), "<init>", desc, 183, mockClass.getCanonicalName().replace('.', '/'), target.getSimpleName(), replacementDesc, true, true));
        }
    }

    private void replaceAllInvokeSpecial(Class<?> mockClass, Class<?> target) throws IllegalArgumentException {
        if (!target.isAssignableFrom(mockClass)) {
            throw new IllegalArgumentException("Method replacement can be done only for subclasses. Class " + mockClass + " is not an instance of " + target);
        }
        for (Method method : mockClass.getMethods()) {
            String desc = Type.getMethodDescriptor((Method)method);
            this.addSpecialReplacementCall(new MethodCallReplacement(target.getCanonicalName().replace('.', '/'), method.getName(), desc, 183, mockClass.getCanonicalName().replace('.', '/'), method.getName(), desc, false, false));
        }
    }
}

