/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import org.evosuite.runtime.instrumentation.MethodCallReplacement;
import org.evosuite.runtime.instrumentation.MethodCallReplacementCache;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;

public class MethodCallReplacementMethodAdapter
extends GeneratorAdapter {
    private final String className;
    private final String superClassName;
    private boolean needToWaitForSuperConstructor = false;
    private boolean hasBeenInstrumented = false;

    public MethodCallReplacementMethodAdapter(MethodVisitor mv, String className, String superClassName, String methodName, int access, String desc) {
        super(327680, mv, access, methodName, desc);
        this.className = className;
        this.superClassName = superClassName;
        if (methodName.equals("<init>")) {
            this.needToWaitForSuperConstructor = true;
        }
    }

    public MethodVisitor getNextVisitor() {
        return this.mv;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        String originalClassNameWithDots;
        MethodCallReplacement replacement;
        boolean isReplaced = false;
        if (MethodCallReplacementCache.getInstance().hasReplacementCall(owner, name + desc) && (opcode != 183 || name.equals("<init>"))) {
            replacement = MethodCallReplacementCache.getInstance().getReplacementCall(owner, name + desc);
            isReplaced = true;
            replacement.insertMethodCall(this, 184);
            this.hasBeenInstrumented = true;
        }
        if (!isReplaced && MethodCallReplacementCache.getInstance().hasSpecialReplacementCall(owner, name + desc) && (replacement = MethodCallReplacementCache.getInstance().getSpecialReplacementCall(owner, name + desc)).isTarget(owner, name, desc) && opcode == 183 && name.equals("<init>")) {
            String originalClassNameWithDots2;
            isReplaced = true;
            this.hasBeenInstrumented = true;
            boolean isSelf = false;
            if (this.needToWaitForSuperConstructor && (originalClassNameWithDots2 = owner.replace('/', '.')).equals(this.superClassName)) {
                isSelf = true;
            }
            if (replacement.getMethodName().equals("<init>")) {
                replacement.insertConstructorCall(this, replacement, isSelf);
            } else {
                replacement.insertMethodCall(this, 183);
            }
        }
        if (!isReplaced) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
        if (this.needToWaitForSuperConstructor && opcode == 183 && (originalClassNameWithDots = owner.replace('/', '.')).equals(this.superClassName)) {
            this.needToWaitForSuperConstructor = false;
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.hasBeenInstrumented) {
            super.visitMaxs(maxStack + 1, maxLocals);
        } else {
            super.visitMaxs(maxStack, maxLocals);
        }
    }
}

