/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import java.util.LinkedHashSet;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class RemoveFinalClassAdapter
extends ClassVisitor {
    public static final Set<String> finalClasses = new LinkedHashSet<String>();

    public RemoveFinalClassAdapter(ClassVisitor cv) {
        super(327680, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x10) == 16) {
            finalClasses.add(name.replace('/', '.'));
        }
        if ((access & 0x400) == 1024 && (access & 1) == 0 && (access & 2) == 0 && (access & 4) == 0) {
            super.visit(version, access & 0xFFFFFFEF | 1, name, signature, superName, interfaces);
        } else {
            super.visit(version, access & 0xFFFFFFEF, name, signature, superName, interfaces);
        }
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if ((access & 0x10) == 16) {
            finalClasses.add(name.replace('/', '.'));
        }
        super.visitInnerClass(name, outerName, innerName, access & 0xFFFFFFEF);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return super.visitMethod(access & 0xFFFFFFEF, name, desc, signature, exceptions);
    }

    public static void reset() {
        finalClasses.clear();
    }
}

