/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.injection;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.faces.bean.ManagedProperty;
import javax.inject.Inject;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.ws.rs.core.Context;
import javax.xml.ws.WebServiceRef;
import org.evosuite.PackageInfo;
import org.evosuite.runtime.util.Inputs;
import org.springframework.beans.factory.annotation.Autowired;

public class InjectionList {
    private static final List<Class<? extends Annotation>> list = Collections.unmodifiableList(Arrays.asList(Inject.class, PersistenceContext.class, PersistenceUnit.class, Resource.class, Autowired.class, EJB.class, WebServiceRef.class, ManagedProperty.class, Context.class));

    public static List<Class<? extends Annotation>> getList() {
        return list;
    }

    public static boolean isValidForInjection(Class<? extends Annotation> annotation) {
        return InjectionList.isValidForInjection(annotation, list);
    }

    public static boolean isValidForInjection(Class<? extends Annotation> annotation, List<Class<? extends Annotation>> tagsToCheck) {
        Inputs.checkNull(annotation);
        String name = annotation.getName();
        String shadedPrefix = PackageInfo.getShadedPackageForThirdPartyLibraries() + ".";
        for (Class<? extends Annotation> c : tagsToCheck) {
            String cn = c.getName();
            if (name.equals(cn)) {
                return true;
            }
            if (!cn.startsWith(shadedPrefix) || !(shadedPrefix + name).equals(cn)) continue;
            return true;
        }
        return false;
    }
}

