/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.javax.servlet.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.evosuite.runtime.annotation.Constraints;
import org.evosuite.runtime.annotation.EvoSuiteAssertionOnly;
import org.evosuite.runtime.annotation.EvoSuiteClassExclude;
import org.evosuite.runtime.annotation.EvoSuiteInclude;
import org.evosuite.runtime.javaee.TestDataJavaEE;
import org.evosuite.runtime.javaee.javax.servlet.EvoAsyncContext;
import org.evosuite.runtime.javaee.javax.servlet.EvoServletState;
import org.evosuite.runtime.javaee.javax.servlet.http.EvoPart;
import org.evosuite.runtime.javaee.javax.servlet.http.HttpMethod;
import org.evosuite.runtime.vnet.VirtualNetwork;

@EvoSuiteClassExclude
public class EvoHttpServletRequest
implements HttpServletRequest {
    public static final String TEXT_XML_CONTENT_FORMAT = "text/xml";
    public static final String TEXT_HTML_CONTENT_FORMAT = "text/html";
    public static final String MULTIPART_FORM_CONTENT_FORMAT = "multipart/form-data";
    private String contextPath = "/EvoSuiteContext";
    private String servletPath = "/EvoSuiteServlet";
    private Integer requestedSessionId = null;
    private HttpMethod method;
    private String contentType;
    private String protocol;
    private String localAddr;
    private String localName;
    private int localPort;
    private String remoteAddr;
    private String remoteHost;
    private int remotePort;
    private Map<String, String[]> parameters;
    private AsyncContext asyncContext;
    private Map<String, EvoPart> parts;
    private String principalName;

    public EvoHttpServletRequest() {
        this.asGET();
        this.contentType = null;
        this.protocol = "HTTP/1.1";
        this.localName = "MockedJavaEEServer";
        this.localAddr = VirtualNetwork.getInstance().dnsResolve(this.localName);
        this.localPort = 80;
        this.remoteHost = "MockedRemoteEvoSuiteRequestClient";
        this.remoteAddr = VirtualNetwork.getInstance().dnsResolve(this.remoteHost);
        this.remotePort = 61386;
        this.parameters = new LinkedHashMap<String, String[]>();
        this.asyncContext = null;
        this.parts = new LinkedHashMap<String, EvoPart>();
    }

    public AsyncContext getAsyncContext() throws IllegalStateException {
        if (this.asyncContext == null) {
            throw new IllegalStateException("Async context not initialized");
        }
        return this.asyncContext;
    }

    @EvoSuiteAssertionOnly
    public boolean isAsyncStarted() {
        return this.asyncContext != null;
    }

    @EvoSuiteAssertionOnly
    public boolean isAsyncSupported() {
        Servlet sut = EvoServletState.getServlet();
        WebServlet annotation = sut.getClass().getAnnotation(WebServlet.class);
        if (annotation == null) {
            return false;
        }
        return annotation.asyncSupported();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.isAsyncSupported() || EvoServletState.getResponse().isCommitted()) {
            throw new IllegalStateException("Cannot start async");
        }
        if (this.asyncContext == null) {
            this.asyncContext = new EvoAsyncContext();
        }
        return this.asyncContext;
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) throws IllegalStateException {
        return null;
    }

    public Object getAttribute(String arg0) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public int getContentLength() {
        return 0;
    }

    public long getContentLengthLong() {
        return 0L;
    }

    public String getContentType() {
        TestDataJavaEE.getInstance().accessContentType();
        return this.contentType;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration<Locale> getLocales() {
        return null;
    }

    public String getParameter(String arg0) {
        String[] params;
        if (arg0 != null) {
            TestDataJavaEE.getInstance().accessedHttpRequestParameter(arg0);
        }
        if ((params = this.getParameterValues(arg0)) != null) {
            return params[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, String[]>(){
            {
                this.putAll(EvoHttpServletRequest.this.parameters);
            }

            @Override
            public Set<String> keySet() {
                final Set set = super.keySet();
                return Collections.unmodifiableSet(new LinkedHashSet<String>(){
                    {
                        this.addAll(set);
                    }

                    @Override
                    public boolean contains(Object k) {
                        if (!(k instanceof String)) {
                            return false;
                        }
                        String val = (String)k;
                        if (val != null && !val.trim().isEmpty()) {
                            TestDataJavaEE.getInstance().accessedHttpRequestParameter(val);
                        }
                        return super.contains(val);
                    }
                });
            }

            @Override
            public boolean containsKey(Object k) {
                if (!(k instanceof String)) {
                    return false;
                }
                String key = (String)k;
                if (key != null && !key.trim().isEmpty()) {
                    TestDataJavaEE.getInstance().accessedHttpRequestParameter(key);
                }
                return super.containsKey(key);
            }
        });
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String arg0) {
        return this.parameters.get(arg0);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRealPath(String arg0) {
        return null;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String arg0) {
    }

    public void setAttribute(String arg0, Object arg1) {
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
    }

    public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
        return false;
    }

    public String changeSessionId() throws IllegalStateException {
        if (this.requestedSessionId == null) {
            throw new IllegalStateException("No current session id");
        }
        Integer n = this.requestedSessionId;
        Integer n2 = this.requestedSessionId = Integer.valueOf(this.requestedSessionId + 1);
        return this.requestedSessionId.toString();
    }

    public String getAuthType() {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public long getDateHeader(String arg0) {
        return 0L;
    }

    public String getHeader(String arg0) {
        return null;
    }

    public Enumeration<String> getHeaderNames() {
        return null;
    }

    public Enumeration<String> getHeaders(String arg0) {
        return null;
    }

    public int getIntHeader(String arg0) {
        return 0;
    }

    public String getMethod() {
        return this.method.toString();
    }

    public Part getPart(String arg0) throws IOException, ServletException {
        if (!MULTIPART_FORM_CONTENT_FORMAT.equals(this.contentType)) {
            throw new ServletException("Cannot access parts if request is not of type multipart/form-data");
        }
        TestDataJavaEE.getInstance().accessPart(arg0);
        return this.parts.get(arg0);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (!MULTIPART_FORM_CONTENT_FORMAT.equals(this.contentType)) {
            throw new ServletException("Cannot access parts if request is not of type multipart/form-data");
        }
        TestDataJavaEE.getInstance().accessPart(null);
        return new ArrayList<Part>(){
            {
                this.addAll(EvoHttpServletRequest.this.parts.values());
            }
        };
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public String getRequestURI() {
        return this.getContextPath() + this.getServletPath();
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId == null ? null : this.requestedSessionId.toString();
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return null;
    }

    public HttpSession getSession(boolean arg0) {
        return null;
    }

    public Principal getUserPrincipal() {
        if (this.principalName == null || this.principalName.trim().isEmpty()) {
            return null;
        }
        return new Principal(){

            @Override
            public String getName() {
                return EvoHttpServletRequest.this.principalName;
            }
        };
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String arg0) {
        return false;
    }

    public void login(String arg0, String arg1) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        return null;
    }

    public String toString() {
        return EvoHttpServletRequest.class.getSimpleName() + " [ " + this.getMethod() + " " + this.getRequestURI() + " ]";
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asGET", "asPUT", "as"})
    public void asPOST() {
        this.setHttpMethod(HttpMethod.POST);
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asPOST", "asPUT", "as"})
    public void asGET() {
        this.setHttpMethod(HttpMethod.GET);
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asGET", "asPOST", "as"})
    public void asPUT() {
        this.setHttpMethod(HttpMethod.PUT);
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asGET", "asPOST", "asPUT"}, noNullInputs=true)
    public void as(HttpMethod m) {
        this.setHttpMethod(m);
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asMultipartFormData", "asTextHtml"}, dependOnProperties={"javaee.servlet.http.contentType"})
    public void asTextXml() {
        this.setContentType(TEXT_XML_CONTENT_FORMAT);
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asTextXml", "asMultipartFormData"}, dependOnProperties={"javaee.servlet.http.contentType"})
    public void asTextHtml() {
        this.setContentType(TEXT_HTML_CONTENT_FORMAT);
    }

    @EvoSuiteInclude
    @Constraints(atMostOnce=true, excludeOthers={"asTextXml", "asTextHtml"}, dependOnProperties={"javaee.servlet.http.contentType"}, after="asPOST")
    public void asMultipartFormData() {
        this.setContentType(MULTIPART_FORM_CONTENT_FORMAT);
    }

    @EvoSuiteInclude
    @Constraints(dependOnProperties={"javaee.servlet.http.param"}, after="asMultipartFormData")
    public void addParam(String key, String value) throws IllegalArgumentException {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Null input");
        }
        String[] params = this.parameters.get(key);
        if (params == null) {
            params = new String[]{value};
        } else {
            params = Arrays.copyOf(params, params.length + 1);
            params[params.length - 1] = value;
        }
        this.parameters.put(key, params);
    }

    @EvoSuiteInclude
    @Constraints(dependOnProperties={"javaee.servlet.http.part"})
    public void addPart(EvoPart p) {
        this.parts.put(p.getName(), p);
    }

    @EvoSuiteInclude
    @Constraints(dependOnProperties={"javaee.servlet.http.principal"})
    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    private void setHttpMethod(HttpMethod m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException("Null input");
        }
        this.method = m;
    }

    private void setContentType(String type) {
        this.contentType = type;
    }
}

