/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import org.evosuite.runtime.mock.java.net.EvoHttpURLConnection;
import org.evosuite.runtime.mock.java.net.MockURLStreamHandler;

public class EvoURLStreamHandler
extends MockURLStreamHandler {
    private final String protocol;

    public EvoURLStreamHandler(String protocol) throws IllegalArgumentException {
        if (protocol == null || protocol.trim().isEmpty()) {
            throw new IllegalArgumentException("Null protocol");
        }
        this.protocol = protocol.trim().toLowerCase();
    }

    public static boolean isValidProtocol(String protocol) {
        if (protocol == null) {
            return false;
        }
        protocol = protocol.trim().toLowerCase();
        List<String> list = Arrays.asList("file", "ftp", "gopher", "http", "https", "jar", "mailto", "netdoc");
        return list.contains(protocol);
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        if (!u.getProtocol().trim().equalsIgnoreCase(this.protocol)) {
            throw new IOException("Error, protocol mismatch: " + u.getProtocol() + " != " + this.protocol);
        }
        if (this.protocol.equals("http") || this.protocol.equals("https")) {
            return new EvoHttpURLConnection(u);
        }
        return null;
    }
}

