/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import org.evosuite.runtime.System;
import org.evosuite.runtime.mock.OverrideMock;

public abstract class MockClock
extends Clock
implements OverrideMock {
    static final int SECONDS_PER_MINUTE = 60;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MINUTE = 60000000000L;

    public static Clock systemUTC() {
        return new MockSystemClock(ZoneOffset.UTC);
    }

    public static Clock systemDefaultZone() {
        return new MockSystemClock(ZoneId.systemDefault());
    }

    public static Clock system(ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        return new MockSystemClock(zone);
    }

    public static Clock tickSeconds(ZoneId zone) {
        return new MockTickClock(MockClock.system(zone), 1000000000L);
    }

    public static Clock tickMinutes(ZoneId zone) {
        return new MockTickClock(MockClock.system(zone), 60000000000L);
    }

    public static Clock tick(Clock baseClock, Duration tickDuration) {
        return Clock.tick(baseClock, tickDuration);
    }

    public static Clock fixed(Instant fixedInstant, ZoneId zone) {
        return Clock.fixed(fixedInstant, zone);
    }

    public static Clock offset(Clock baseClock, Duration offsetDuration) {
        return Clock.offset(baseClock, offsetDuration);
    }

    protected MockClock() {
    }

    @Override
    public abstract ZoneId getZone();

    @Override
    public abstract Clock withZone(ZoneId var1);

    @Override
    public long millis() {
        return this.instant().toEpochMilli();
    }

    @Override
    public abstract Instant instant();

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    static final class MockTickClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 6504659149906368850L;
        private final Clock baseClock;
        private final long tickNanos;

        MockTickClock(Clock baseClock, long tickNanos) {
            this.baseClock = baseClock;
            this.tickNanos = tickNanos;
        }

        @Override
        public ZoneId getZone() {
            return this.baseClock.getZone();
        }

        @Override
        public Clock withZone(ZoneId zone) {
            if (zone.equals(this.baseClock.getZone())) {
                return this;
            }
            return new MockTickClock(this.baseClock.withZone(zone), this.tickNanos);
        }

        @Override
        public long millis() {
            long millis = this.baseClock.millis();
            return millis - Math.floorMod(millis, this.tickNanos / 1000000L);
        }

        @Override
        public Instant instant() {
            if (this.tickNanos % 1000000L == 0L) {
                long millis = this.baseClock.millis();
                return Instant.ofEpochMilli(millis - Math.floorMod(millis, this.tickNanos / 1000000L));
            }
            Instant instant = this.baseClock.instant();
            long nanos = instant.getNano();
            long adjust = Math.floorMod(nanos, this.tickNanos);
            return instant.minusNanos(adjust);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof MockTickClock) {
                MockTickClock other = (MockTickClock)obj;
                return this.baseClock.equals(other.baseClock) && this.tickNanos == other.tickNanos;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.baseClock.hashCode() ^ (int)(this.tickNanos ^ this.tickNanos >>> 32);
        }

        public String toString() {
            return "TickClock[" + this.baseClock + "," + Duration.ofNanos(this.tickNanos) + "]";
        }
    }

    static final class MockSystemClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 6740630888130243051L;
        private final ZoneId zone;

        MockSystemClock(ZoneId zone) {
            this.zone = zone;
        }

        @Override
        public ZoneId getZone() {
            return this.zone;
        }

        @Override
        public Clock withZone(ZoneId zone) {
            if (zone.equals(this.zone)) {
                return this;
            }
            return new MockSystemClock(zone);
        }

        @Override
        public long millis() {
            return System.currentTimeMillis();
        }

        @Override
        public Instant instant() {
            return Instant.ofEpochMilli(this.millis());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof MockSystemClock) {
                return this.zone.equals(((MockSystemClock)obj).zone);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.zone.hashCode() + 1;
        }

        public String toString() {
            return "SystemClock[" + this.zone + "]";
        }
    }
}

