/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.javax.swing;

import java.awt.Component;
import java.awt.HeadlessException;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.util.JOptionPaneInputs;

public abstract class MockJOptionPane
extends JOptionPane
implements OverrideMock {
    private static final long serialVersionUID = 1531475063681545845L;

    public static void showMessageDialog(Component parentComponent, Object message) {
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
    }

    public static int showConfirmDialog(Component parentComponent, Object message) throws HeadlessException {
        return MockJOptionPane.showConfirmDialog(1);
    }

    private static int showConfirmDialog(int optionType) {
        switch (optionType) {
            case -1: 
            case 1: {
                return MockJOptionPane.getInputYesNoCancelSelection();
            }
            case 0: {
                return MockJOptionPane.getInputYesNoSelection();
            }
            case 2: {
                return MockJOptionPane.getInputOkCancelSelection();
            }
        }
        throw new IllegalStateException("Option number " + optionType + " does not match any known JOptionPane option");
    }

    private static int getInputOkCancelSelection() {
        JOptionPaneInputs.getInstance().addDialog(JOptionPaneInputs.GUIAction.OK_CANCEL_SELECTION);
        if (JOptionPaneInputs.getInstance().containsOkCancelSelection()) {
            int str = JOptionPaneInputs.getInstance().dequeueOkCancelSelection();
            return str;
        }
        return -1;
    }

    private static int getInputYesNoSelection() {
        JOptionPaneInputs.getInstance().addDialog(JOptionPaneInputs.GUIAction.YES_NO_SELECTION);
        if (JOptionPaneInputs.getInstance().containsYesNoSelection()) {
            int str = JOptionPaneInputs.getInstance().dequeueYesNoSelection();
            return str;
        }
        return -1;
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) throws HeadlessException {
        return MockJOptionPane.showConfirmDialog(optionType);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) throws HeadlessException {
        return MockJOptionPane.showConfirmDialog(optionType);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) throws HeadlessException {
        return MockJOptionPane.showConfirmDialog(optionType);
    }

    public static String showInputDialog(Object message) throws HeadlessException {
        return MockJOptionPane.getStringInput();
    }

    private static String getStringInput() {
        JOptionPaneInputs.getInstance().addDialog(JOptionPaneInputs.GUIAction.STRING_INPUT);
        if (JOptionPaneInputs.getInstance().containsStringInput()) {
            String str = JOptionPaneInputs.getInstance().dequeueStringInput();
            return str;
        }
        return null;
    }

    private static int getInputYesNoCancelSelection() {
        JOptionPaneInputs.getInstance().addDialog(JOptionPaneInputs.GUIAction.YES_NO_CANCEL_SELECTION);
        if (JOptionPaneInputs.getInstance().containsYesNoCancelSelection()) {
            int str = JOptionPaneInputs.getInstance().dequeueYesNoCancelSelection();
            return str;
        }
        return -1;
    }

    public static String showInputDialog(Object message, Object initialSelectionValue) {
        return MockJOptionPane.getStringInput();
    }

    public static String showInputDialog(Component parentComponent, Object message) throws HeadlessException {
        return MockJOptionPane.getStringInput();
    }

    public static String showInputDialog(Component parentComponent, Object message, Object initialSelectionValue) {
        return MockJOptionPane.getStringInput();
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType) throws HeadlessException {
        return MockJOptionPane.getStringInput();
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message) {
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message, String title, int messageType) {
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message) {
        return MockJOptionPane.showConfirmDialog(1);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType) {
        return MockJOptionPane.showConfirmDialog(optionType);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        return MockJOptionPane.showConfirmDialog(optionType);
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        return MockJOptionPane.showConfirmDialog(optionType);
    }

    public static String showInternalInputDialog(Component parentComponent, Object message) {
        return MockJOptionPane.getStringInput();
    }

    public static String showInternalInputDialog(Component parentComponent, Object message, String title, int messageType) {
        return MockJOptionPane.getStringInput();
    }

    public static int showInternalOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) throws HeadlessException {
        return MockJOptionPane.getOptionSelectionInt(options == null, options == null ? 0 : options.length);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) throws HeadlessException {
        return MockJOptionPane.getOptionSelectionInt(options == null, options == null ? 0 : options.length);
    }

    private static int getOptionSelectionInt(boolean optionsIsNull, int optionsLength) {
        JOptionPaneInputs.getInstance().addDialog(JOptionPaneInputs.GUIAction.OPTION_SELECTION);
        if (JOptionPaneInputs.getInstance().containsOptionSelection()) {
            int selection = JOptionPaneInputs.getInstance().dequeueOptionSelection();
            if (selection < -1) {
                return -1;
            }
            if (optionsIsNull) {
                return 0;
            }
            if (selection >= optionsLength) {
                return optionsLength - 1;
            }
            return selection;
        }
        return -1;
    }

    private static Object getOptionSelectionInt(Object[] options) {
        JOptionPaneInputs.getInstance().addDialog(JOptionPaneInputs.GUIAction.OPTION_SELECTION);
        if (JOptionPaneInputs.getInstance().containsOptionSelection()) {
            int selection = JOptionPaneInputs.getInstance().dequeueOptionSelection();
            if (selection < 0 || options == null) {
                return null;
            }
            if (selection >= options.length) {
                return options[options.length - 1];
            }
            return options[selection];
        }
        return null;
    }

    public static Object showInternalInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] options, Object initialSelectionValue) {
        return MockJOptionPane.getOptionSelectionInt(options);
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] options, Object initialSelectionValue) throws HeadlessException {
        return MockJOptionPane.getOptionSelectionInt(options);
    }
}

