/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.testdata;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.evosuite.runtime.mock.java.net.MockInetAddress;
import org.evosuite.runtime.testdata.EvoSuiteLocalAddress;
import org.evosuite.runtime.testdata.EvoSuiteRemoteAddress;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.runtime.vnet.EndPointInfo;
import org.evosuite.runtime.vnet.NativeTcp;
import org.evosuite.runtime.vnet.RemoteTcpServer;
import org.evosuite.runtime.vnet.VirtualNetwork;

public class NetworkHandling {
    private static final String DEFAULT_REMOTE_ADDRESS = "192.168.0.99";

    public static boolean openRemoteTcpServer(EvoSuiteRemoteAddress remoteServer) {
        if (remoteServer == null) {
            return false;
        }
        RemoteTcpServer server = new RemoteTcpServer(new EndPointInfo(remoteServer.getHost(), remoteServer.getPort(), VirtualNetwork.ConnectionType.TCP));
        VirtualNetwork.getInstance().addRemoteTcpServer(server);
        return true;
    }

    public static boolean sendDataOnTcp(EvoSuiteLocalAddress sutServer, byte[] data) {
        if (sutServer == null) {
            return false;
        }
        NativeTcp connection = VirtualNetwork.getInstance().registerIncomingTcpConnection(DEFAULT_REMOTE_ADDRESS, VirtualNetwork.getInstance().getNewRemoteEphemeralPort(), sutServer.getHost(), sutServer.getPort());
        if (data != null) {
            for (byte b : data) {
                connection.writeToSUT(b);
            }
        }
        return true;
    }

    public static boolean sendMessageOnTcp(EvoSuiteLocalAddress sutServer, String message) {
        return NetworkHandling.sendDataOnTcp(sutServer, message.getBytes());
    }

    public static boolean sendUdpPacket(EvoSuiteLocalAddress sutAddress, byte[] data) {
        return NetworkHandling.sendUdpPacket(sutAddress, new EvoSuiteRemoteAddress(DEFAULT_REMOTE_ADDRESS, VirtualNetwork.getInstance().getNewRemoteEphemeralPort()), data);
    }

    public static boolean sendUdpPacket(EvoSuiteLocalAddress sutAddress, EvoSuiteRemoteAddress remoteAddress, byte[] data) {
        if (sutAddress == null) {
            return false;
        }
        if (data == null) {
            data = new byte[]{};
        }
        InetAddress address = null;
        try {
            address = MockInetAddress.getByName(remoteAddress.getHost());
        }
        catch (UnknownHostException e) {
            return false;
        }
        VirtualNetwork.getInstance().sendPacketToSUT(data, address, remoteAddress.getPort(), sutAddress.getHost(), sutAddress.getPort());
        return true;
    }

    public static boolean createRemoteTextFile(EvoSuiteURL url, String text) {
        if (url == null) {
            return false;
        }
        return VirtualNetwork.getInstance().addRemoteTextFile(url.getUrl(), text);
    }
}

