/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.util;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.runtime.util.Inputs;
import org.slf4j.Logger;

public class AtMostOnceLogger {
    private static final Map<Logger, Set<String>> atMostOnceLogs = new ConcurrentHashMap<Logger, Set<String>>();

    private static synchronized void logAtMostOnce(Logger logger, String message, boolean error) {
        Inputs.checkNull(logger, message);
        Set<String> previous = atMostOnceLogs.get(logger);
        if (previous == null) {
            previous = new LinkedHashSet<String>();
            atMostOnceLogs.put(logger, previous);
        }
        if (!previous.contains(message)) {
            previous.add(message);
            if (error) {
                logger.error(message);
            } else {
                logger.warn(message);
            }
        }
    }

    public static void warn(Logger logger, String message) {
        AtMostOnceLogger.logAtMostOnce(logger, message, false);
    }

    public static void error(Logger logger, String message) {
        AtMostOnceLogger.logAtMostOnce(logger, message, true);
    }
}

