/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.evosuite.runtime.instrumentation.InstrumentedClass;
import org.evosuite.runtime.instrumentation.RemoveFinalClassAdapter;
import org.evosuite.runtime.util.ReflectionUtils;

public class Reflection {
    private static <T> T[] sortArrayInPlace(T[] original) {
        List<T> methods = Arrays.asList(original);
        Collections.sort(methods, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        methods.toArray(original);
        return original;
    }

    public static Annotation[] getAnnotations(Class<?> clazz) throws SecurityException {
        return Reflection.sortArrayInPlace(ReflectionUtils.getAnnotations(clazz));
    }

    public static Class<?>[] getClasses(Class<?> clazz) throws SecurityException {
        return Reflection.sortArrayInPlace(ReflectionUtils.getClasses(clazz));
    }

    public static Method[] getMethods(Class<?> clazz) throws SecurityException {
        return Reflection.sortArrayInPlace(ReflectionUtils.getMethods(clazz));
    }

    public static Field[] getFields(Class<?> clazz) throws SecurityException {
        return Reflection.sortArrayInPlace(ReflectionUtils.getFields(clazz));
    }

    public static Constructor<?>[] getConstructors(Class<?> clazz) throws SecurityException {
        return Reflection.sortArrayInPlace(ReflectionUtils.getConstructors(clazz));
    }

    public static Class<?>[] getInterfaces(Class<?> clazz) throws SecurityException {
        return (Class[])Reflection.sortArrayInPlace(Arrays.stream(ReflectionUtils.getInterfaces(clazz)).filter(c -> !c.equals(InstrumentedClass.class)).toArray(Class[]::new));
    }

    public static Annotation[] getDeclaredAnnotations(Class<?> clazz) throws SecurityException {
        return Reflection.sortArrayInPlace(ReflectionUtils.getDeclaredAnnotations(clazz));
    }

    public static Annotation[] getDeclaredAnnotations(Field field) throws SecurityException {
        return Reflection.sortArrayInPlace(ReflectionUtils.getDeclaredAnnotations(field));
    }

    public static Class<?>[] getDeclaredClasses(Class<?> clazz) throws SecurityException {
        return Reflection.sortArrayInPlace(ReflectionUtils.getDeclaredClasses(clazz));
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) throws SecurityException {
        return Reflection.sortArrayInPlace(ReflectionUtils.getDeclaredMethods(clazz));
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws SecurityException {
        return Reflection.sortArrayInPlace(ReflectionUtils.getDeclaredFields(clazz));
    }

    public static Constructor<?>[] getDeclaredConstructors(Class<?> clazz) throws SecurityException {
        return Reflection.sortArrayInPlace(ReflectionUtils.getDeclaredConstructors(clazz));
    }

    public static int getModifiers(Class<?> clazz) {
        int modifier = clazz.getModifiers();
        if (RemoveFinalClassAdapter.finalClasses.contains(clazz.getCanonicalName())) {
            modifier |= 0x10;
        }
        return modifier;
    }

    public static void setField(Field field, Object sourceObject, Object value) throws IllegalAccessException {
        if (field.getType().equals(Integer.TYPE)) {
            field.setInt(sourceObject, Reflection.getIntValue(value));
        } else if (field.getType().equals(Boolean.TYPE)) {
            field.setBoolean(sourceObject, (Boolean)value);
        } else if (field.getType().equals(Byte.TYPE)) {
            field.setByte(sourceObject, (byte)Reflection.getIntValue(value));
        } else if (field.getType().equals(Character.TYPE)) {
            field.setChar(sourceObject, Reflection.getCharValue(value));
        } else if (field.getType().equals(Double.TYPE)) {
            field.setDouble(sourceObject, Reflection.getDoubleValue(value));
        } else if (field.getType().equals(Float.TYPE)) {
            field.setFloat(sourceObject, Reflection.getFloatValue(value));
        } else if (field.getType().equals(Long.TYPE)) {
            field.setLong(sourceObject, Reflection.getLongValue(value));
        } else if (field.getType().equals(Short.TYPE)) {
            field.setShort(sourceObject, (short)Reflection.getIntValue(value));
        } else {
            field.set(sourceObject, value);
        }
    }

    private static int getIntValue(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return 0;
    }

    private static long getLongValue(Object object) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return 0L;
    }

    private static float getFloatValue(Object object) {
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return 0.0f;
    }

    private static double getDoubleValue(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return 0.0;
    }

    private static char getCharValue(Object object) {
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Number) {
            return (char)((Number)object).intValue();
        }
        return '0';
    }
}

