/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.evosuite.runtime.javaee.JeeData;
import org.evosuite.runtime.util.Inputs;

public class TestDataJavaEE {
    public static final String HTTP_REQUEST_CONTENT_TYPE = "javaee.servlet.http.contentType";
    public static final String HTTP_REQUEST_PARAM = "javaee.servlet.http.param";
    public static final String HTTP_REQUEST_PART = "javaee.servlet.http.part";
    public static final String HTTP_REQUEST_PRINCIPAL = "javaee.servlet.http.principal";
    private static final TestDataJavaEE singleton = new TestDataJavaEE();
    private final Set<String> httpRequestParameters = new CopyOnWriteArraySet<String>();
    private final Set<String> dispatchers = new CopyOnWriteArraySet<String>();
    private volatile boolean readContentType = false;
    private volatile Set<String> partNames = null;
    private volatile boolean wasAServletInitialized;
    private final Set<String> lookedUpContextNames = new CopyOnWriteArraySet<String>();

    private TestDataJavaEE() {
    }

    public static TestDataJavaEE getInstance() {
        return singleton;
    }

    public void reset() {
        this.httpRequestParameters.clear();
        this.dispatchers.clear();
        this.lookedUpContextNames.clear();
        this.readContentType = false;
        this.partNames = null;
        this.wasAServletInitialized = false;
    }

    public JeeData getJeeData() {
        return new JeeData(this.httpRequestParameters, this.dispatchers, this.readContentType, this.partNames, this.wasAServletInitialized, this.lookedUpContextNames);
    }

    public Set<String> getViewOfLookedUpContextNames() {
        return Collections.unmodifiableSet(this.lookedUpContextNames);
    }

    public void accessLookUpContextName(String name) {
        Inputs.checkNull(name);
        this.lookedUpContextNames.add(name);
    }

    public boolean isWasAServletInitialized() {
        return this.wasAServletInitialized;
    }

    public void setWasAServletInitialized(boolean wasAServletInitialized) {
        this.wasAServletInitialized = wasAServletInitialized;
    }

    public Set<String> getViewOfHttpRequestParameters() {
        return Collections.unmodifiableSet(this.httpRequestParameters);
    }

    public Set<String> getViewOfDispatchers() {
        return Collections.unmodifiableSet(this.dispatchers);
    }

    public Set<String> getViewOfParts() {
        if (this.partNames == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.partNames);
    }

    public boolean wasContentTypeRead() {
        return this.readContentType;
    }

    public void accessPart(String name) {
        if (this.partNames == null) {
            this.partNames = new CopyOnWriteArraySet<String>();
        }
        if (name != null) {
            this.partNames.add(name);
        }
    }

    public void accessContentType() {
        this.readContentType = true;
    }

    public void accessedDispatcher(String dispatcherName) throws IllegalArgumentException {
        Inputs.checkNull(dispatcherName);
        this.dispatchers.add(dispatcherName);
    }

    public void accessedHttpRequestParameter(String param) throws IllegalArgumentException {
        Inputs.checkNull(param);
        this.httpRequestParameters.add(param);
    }
}

