/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.javaee.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.runtime.Reflection;
import org.evosuite.runtime.javaee.injection.InjectionCache;
import org.evosuite.runtime.javaee.injection.InjectionList;
import org.evosuite.runtime.util.Inputs;

public class GeneralInjection {
    private final Map<Class<?>, List<Field>> cache = new LinkedHashMap();
    private final Map<Class<?>, InjectionCache> specials = new LinkedHashMap();

    public GeneralInjection(InjectionCache ... specials) throws IllegalArgumentException {
        for (InjectionCache ic : specials) {
            Class<?> fieldClass = ic.getFieldClass();
            if (this.specials.containsKey(fieldClass)) {
                throw new IllegalArgumentException("Field of type " + fieldClass + "has more than one cache");
            }
            this.specials.put(fieldClass, ic);
        }
    }

    public void reset() {
        this.cache.clear();
    }

    public List<Field> getFieldsToInject(Class<?> klass) throws IllegalArgumentException {
        Inputs.checkNull(klass);
        List<Field> fields = this.cache.get(klass);
        if (fields == null) {
            fields = new ArrayList<Field>();
            block0: for (Field f : Reflection.getDeclaredFields(klass)) {
                Class<?> fieldClass = f.getType();
                if (this.specials.containsKey(fieldClass)) continue;
                for (Annotation annotation : Reflection.getDeclaredAnnotations(f)) {
                    Class<? extends Annotation> annotationClass = annotation.annotationType();
                    if (!InjectionList.isValidForInjection(annotationClass)) continue;
                    fields.add(f);
                    continue block0;
                }
            }
            fields.sort((a, b) -> a.getName().compareTo(b.getName()));
            this.cache.put(klass, fields);
        }
        return new ArrayList<Field>(fields);
    }
}

