/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.evosuite.runtime.LeakingResource;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.io.EvoFileChannel;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockIOException;
import org.evosuite.runtime.mock.java.io.NativeMockedIO;
import org.evosuite.runtime.mock.java.lang.MockNullPointerException;
import org.evosuite.runtime.vfs.VFile;
import org.evosuite.runtime.vfs.VirtualFileSystem;

public class MockFileInputStream
extends FileInputStream
implements LeakingResource,
OverrideMock {
    private FileChannel channel = null;
    private volatile boolean closed = false;
    private final String path;
    private final AtomicInteger position = new AtomicInteger(0);

    public MockFileInputStream(String name) throws FileNotFoundException {
        this(name != null ? (!MockFramework.isEnabled() ? new File(name) : new MockFile(name)) : (File)null);
    }

    public MockFileInputStream(File file) throws FileNotFoundException {
        super(!MockFramework.isEnabled() ? file : VirtualFileSystem.getInstance().getRealTmpFile());
        if (!MockFramework.isEnabled()) {
            this.path = null;
            return;
        }
        VirtualFileSystem.getInstance().addLeakingResource(this);
        String string = this.path = file != null ? file.getAbsolutePath() : null;
        if (this.path == null) {
            throw new MockNullPointerException();
        }
        VFile vf = NativeMockedIO.getFileForReading(this.path);
        if (vf == null) {
            throw new FileNotFoundException();
        }
    }

    public MockFileInputStream(FileDescriptor fdObj) {
        super(fdObj);
        this.path = "";
    }

    @Override
    public int read() throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.read();
        }
        this.throwExceptionIfClosed();
        return NativeMockedIO.read(this.path, this.position);
    }

    private int readBytes(byte[] b, int off, int len) throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.read(b, off, len);
        }
        int counter = 0;
        for (int i = 0; i < len; ++i) {
            int v = this.read();
            if (v == -1) {
                if (i == 0) {
                    return -1;
                }
                return counter;
            }
            b[off + i] = (byte)v;
            ++counter;
        }
        return counter;
    }

    @Override
    public long skip(long n) throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.skip(n);
        }
        if (n < 0L) {
            throw new MockIOException();
        }
        this.throwExceptionIfClosed();
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded(this.path);
        this.position.addAndGet((int)n);
        return n;
    }

    @Override
    public int available() throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.available();
        }
        this.throwExceptionIfClosed();
        VFile vf = NativeMockedIO.getFileForReading(this.path);
        if (vf == null) {
            throw new MockIOException();
        }
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded(this.path);
        int size = vf.getDataSize();
        int available = size - this.position.get();
        return available;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (!MockFramework.isEnabled()) {
            return;
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.channel != null) {
            this.channel.close();
        }
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded(this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel getChannel() {
        if (!MockFramework.isEnabled()) {
            return super.getChannel();
        }
        MockFileInputStream mockFileInputStream = this;
        synchronized (mockFileInputStream) {
            if (this.channel == null) {
                this.channel = new EvoFileChannel(this.position, this.path, true, false);
            }
            return this.channel;
        }
    }

    private void throwExceptionIfClosed() throws IOException {
        if (this.closed) {
            throw new MockIOException();
        }
    }

    @Override
    public void release() throws Exception {
        super.close();
    }
}

