/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.evosuite.runtime.LeakingResource;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.io.EvoFileChannel;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockIOException;
import org.evosuite.runtime.mock.java.io.NativeMockedIO;
import org.evosuite.runtime.mock.java.lang.MockIllegalArgumentException;
import org.evosuite.runtime.mock.java.lang.MockNullPointerException;
import org.evosuite.runtime.vfs.VirtualFileSystem;

public class MockRandomAccessFile
extends RandomAccessFile
implements LeakingResource,
OverrideMock {
    private FileChannel channel = null;
    private final Object closeLock = new Object();
    private boolean canRead;
    private boolean canWrite;
    private volatile boolean closed = false;
    private final String path;
    private final AtomicInteger position = new AtomicInteger(0);

    public MockRandomAccessFile(String name, String mode) throws FileNotFoundException {
        this(name != null ? (!MockFramework.isEnabled() ? new File(name) : new MockFile(name)) : null, mode);
    }

    public MockRandomAccessFile(File file, String mode) throws FileNotFoundException {
        super(!MockFramework.isEnabled() ? file : VirtualFileSystem.getInstance().getRealTmpFile(), mode);
        String name;
        if (!MockFramework.isEnabled()) {
            this.path = null;
            return;
        }
        VirtualFileSystem.getInstance().addLeakingResource(this);
        String string = name = file != null ? file.getPath() : null;
        if (mode == null || !mode.equals("r") && !mode.equals("rw") && !mode.equals("rws") && !mode.equals("rwd")) {
            throw new MockIllegalArgumentException("Illegal mode \"" + mode + "\" must be one of \"r\", \"rw\", \"rws\", or \"rwd\"");
        }
        this.canRead = mode.contains("r");
        assert (this.canRead);
        this.canWrite = mode.contains("w");
        if (name == null) {
            throw new MockNullPointerException();
        }
        this.path = file != null ? file.getAbsolutePath() : null;
        boolean exist = VirtualFileSystem.getInstance().exists(this.path);
        if (!exist) {
            if (!this.canWrite) {
                throw new FileNotFoundException("File does not exist, and RandomAccessFile is not open in write mode");
            }
            boolean created = VirtualFileSystem.getInstance().createFile(this.path);
            if (!created) {
                throw new FileNotFoundException("Failed to create file");
            }
        }
        this.channel = new EvoFileChannel(this.position, this.path, this.canRead, this.canWrite);
    }

    @Override
    public int read() throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.read();
        }
        if (this.closed) {
            throw new MockIOException();
        }
        assert (this.canRead);
        return NativeMockedIO.read(this.path, this.position);
    }

    @Override
    public void write(int b) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.write(b);
            return;
        }
        this.writeBytes(new byte[]{(byte)b}, 0, 1);
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        if (this.closed || !this.canWrite) {
            throw new IOException();
        }
        NativeMockedIO.writeBytes(this.path, this.position, b, off, len);
    }

    @Override
    public long getFilePointer() throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.getFilePointer();
        }
        return this.position.get();
    }

    @Override
    public void seek(long pos) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.seek(pos);
            return;
        }
        if (pos < 0L) {
            throw new MockIOException("Negative position: " + pos);
        }
        if (pos > Integer.MAX_VALUE) {
            throw new MockIOException("Virtual file system does not handle files larger than  2147483647 bytes");
        }
        this.position.set((int)pos);
    }

    @Override
    public long length() throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.length();
        }
        if (this.closed) {
            throw new MockIOException();
        }
        return NativeMockedIO.size(this.path);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.setLength(newLength);
            return;
        }
        if (this.closed || !this.canWrite) {
            throw new IOException();
        }
        NativeMockedIO.setLength(this.path, this.position, newLength);
    }

    private int readBytes(byte[] b, int off, int len) throws IOException {
        int counter = 0;
        for (int i = 0; i < len; ++i) {
            int v = this.read();
            if (v == -1) {
                return -1;
            }
            b[off + i] = (byte)v;
            ++counter;
        }
        return counter;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.read(b, off, len);
        }
        return this.readBytes(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.read(b);
        }
        return this.readBytes(b, 0, b.length);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.skipBytes(n);
        }
        return super.skipBytes(n);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.write(b);
            return;
        }
        this.writeBytes(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!MockFramework.isEnabled()) {
            super.write(b, off, len);
            return;
        }
        this.writeBytes(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!MockFramework.isEnabled()) {
            super.close();
            return;
        }
        Object object = this.closeLock;
        synchronized (object) {
            super.close();
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded(this.path);
    }

    @Override
    public void release() throws Exception {
        super.close();
    }
}

