/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.util.logging;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.ErrorManager;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.vfs.VirtualFileSystem;

public class MockFileHandler
extends FileHandler
implements OverrideMock {
    private static final int offValue = Level.OFF.intValue();
    private Filter filter;
    private Formatter formatter;
    private Level logLevel = Level.ALL;
    private ErrorManager errorManager = new ErrorManager();
    private String encoding;

    public MockFileHandler() throws IOException, SecurityException {
        super(".tmp_file_needed_by_mock_of_FileHandler", true);
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded(null);
    }

    public MockFileHandler(String pattern) throws IOException, SecurityException {
        this();
        if (pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
    }

    public MockFileHandler(String pattern, boolean append) throws IOException, SecurityException {
        this();
        if (pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
    }

    public MockFileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
        this();
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
    }

    public MockFileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        this();
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
    }

    @Override
    public synchronized void close() throws SecurityException {
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (record == null) {
            return false;
        }
        int levelValue = this.getLevel().intValue();
        if (record.getLevel().intValue() < levelValue || levelValue == offValue) {
            return false;
        }
        Filter filter = this.getFilter();
        if (filter == null) {
            return true;
        }
        return filter.isLoggable(record);
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public void setFormatter(Formatter newFormatter) throws SecurityException {
        newFormatter.getClass();
        this.formatter = newFormatter;
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        if (encoding != null) {
            try {
                if (!Charset.isSupported(encoding)) {
                    throw new UnsupportedEncodingException(encoding);
                }
            }
            catch (IllegalCharsetNameException e) {
                throw new UnsupportedEncodingException(encoding);
            }
        }
        this.encoding = encoding;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        this.filter = newFilter;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setErrorManager(ErrorManager em) {
        if (em == null) {
            throw new NullPointerException();
        }
        this.errorManager = em;
    }

    @Override
    public ErrorManager getErrorManager() {
        return this.errorManager;
    }

    @Override
    public synchronized void setLevel(Level newLevel) throws SecurityException {
        if (newLevel == null) {
            throw new NullPointerException();
        }
        this.logLevel = newLevel;
    }

    @Override
    public synchronized Level getLevel() {
        return this.logLevel;
    }
}

