/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);

    public static Class<?>[] getDeclaredClasses(Class<?> clazz) {
        try {
            return clazz.getDeclaredClasses();
        }
        catch (NoClassDefFoundError e) {
            logger.info("Error while analyzing all classes of class " + clazz + ": " + e);
            return new Class[0];
        }
    }

    public static Class<?>[] getClasses(Class<?> clazz) {
        try {
            return clazz.getClasses();
        }
        catch (NoClassDefFoundError e) {
            logger.info("Error while analyzing all classes of class " + clazz + ": " + e);
            return new Class[0];
        }
    }

    public static Constructor<?>[] getDeclaredConstructors(Class<?> clazz) {
        try {
            return clazz.getDeclaredConstructors();
        }
        catch (NoClassDefFoundError e) {
            logger.info("Error while analyzing declared constructors of class " + clazz + ": " + e);
            return new Constructor[0];
        }
    }

    public static Constructor<?>[] getConstructors(Class<?> clazz) {
        try {
            return clazz.getConstructors();
        }
        catch (NoClassDefFoundError e) {
            logger.info("Error while analyzing constructors of class " + clazz + ": " + e);
            return new Constructor[0];
        }
    }

    public static Class<?>[] getInterfaces(Class<?> clazz) {
        try {
            return clazz.getInterfaces();
        }
        catch (NoClassDefFoundError e) {
            logger.info("Error while analyzing interfaces of class " + clazz + ": " + e);
            return new Class[0];
        }
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        try {
            return clazz.getDeclaredMethods();
        }
        catch (NoClassDefFoundError e) {
            logger.info("Error while trying to load declared methods of class " + clazz.getName() + ": " + e);
            return new Method[0];
        }
    }

    public static Method[] getMethods(Class<?> clazz) {
        try {
            return clazz.getMethods();
        }
        catch (NoClassDefFoundError e) {
            logger.info("Error while trying to load methods of class " + clazz.getName() + ": " + e);
            return new Method[0];
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        try {
            return clazz.getDeclaredFields();
        }
        catch (NoClassDefFoundError e) {
            logger.info("Error while trying to load declared fields of class " + clazz.getName() + ": " + e);
            return new Field[0];
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoClassDefFoundError | NoSuchFieldException e) {
            logger.info("Error while trying to load declared field '" + fieldName + "' of class " + clazz.getName() + ": " + e);
            return null;
        }
    }

    public static Field[] getFields(Class<?> clazz) {
        try {
            return clazz.getFields();
        }
        catch (NoClassDefFoundError e) {
            logger.info("Error while trying to load fields of class " + clazz.getName() + ": " + e);
            return new Field[0];
        }
    }

    public static Annotation[] getDeclaredAnnotations(Class<?> clazz) {
        return clazz.getDeclaredAnnotations();
    }

    public static Annotation[] getAnnotations(Class<?> clazz) {
        return clazz.getAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Field field) {
        return field.getDeclaredAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Method method) {
        return method.getDeclaredAnnotations();
    }
}

