/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.vfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.evosuite.runtime.LeakingResource;
import org.evosuite.runtime.sandbox.MSecurityManager;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.vfs.FSObject;
import org.evosuite.runtime.vfs.VFile;
import org.evosuite.runtime.vfs.VFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VirtualFileSystem {
    private static final Logger logger = LoggerFactory.getLogger(VirtualFileSystem.class);
    private static final VirtualFileSystem singleton = new VirtualFileSystem();
    private VFolder root;
    private final AtomicInteger tmpFileCounter = new AtomicInteger(0);
    private final Set<String> accessedFiles = new CopyOnWriteArraySet<String>();
    private volatile boolean shouldAllThrowIOException;
    private final Set<String> classesThatShouldThrowIOException;
    private final Set<LeakingResource> leakingResources = new CopyOnWriteArraySet<LeakingResource>();

    private VirtualFileSystem() {
        this.classesThatShouldThrowIOException = new CopyOnWriteArraySet<String>();
    }

    public static VirtualFileSystem getInstance() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSingleton() {
        this.root = null;
        this.tmpFileCounter.set(0);
        this.accessedFiles.clear();
        this.shouldAllThrowIOException = false;
        this.classesThatShouldThrowIOException.clear();
        Set<LeakingResource> set = this.leakingResources;
        synchronized (set) {
            for (LeakingResource resource : this.leakingResources) {
                try {
                    resource.release();
                }
                catch (Exception e) {
                    logger.warn("Failed to release resource: " + e.getMessage(), e);
                }
            }
            this.leakingResources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLeakingResource(LeakingResource resource) {
        Set<LeakingResource> set = this.leakingResources;
        synchronized (set) {
            this.leakingResources.add(resource);
        }
    }

    public File getRealTmpFile() {
        return MSecurityManager.getRealTmpFile();
    }

    public void throwSimuledIOExceptionIfNeeded(String path) throws IOException {
        if (this.isClassSupposedToThrowIOException(path)) {
            throw new IOException("Simulated IOException");
        }
    }

    public boolean isClassSupposedToThrowIOException(String path) {
        return this.shouldAllThrowIOException || this.classesThatShouldThrowIOException.contains(path);
    }

    public boolean setShouldThrowIOException(EvoSuiteFile file) {
        String path = file.getPath();
        if (this.classesThatShouldThrowIOException.contains(path)) {
            return false;
        }
        this.classesThatShouldThrowIOException.add(path);
        return true;
    }

    public boolean setShouldAllThrowIOExceptions() {
        if (this.shouldAllThrowIOException) {
            return false;
        }
        this.shouldAllThrowIOException = true;
        return true;
    }

    public void init() {
        this.root = new VFolder(null, null);
        String workingDir = VirtualFileSystem.getWorkingDirPath();
        this.createFolder(workingDir);
        this.createFolder(this.getTmpFolderPath());
        this.accessedFiles.clear();
    }

    public static String getWorkingDirPath() {
        return System.getProperty("user.dir");
    }

    public static String getDefaultParent() {
        return File.separator;
    }

    private void markAccessedFile(String path) {
        if (path.contains("\"")) {
            return;
        }
        this.accessedFiles.add(path);
    }

    public Set<String> getAccessedFiles() {
        return new HashSet<String>(this.accessedFiles);
    }

    public String createTempFile(String prefix, String suffix, File directory) throws IllegalArgumentException, IOException {
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        String folder = null;
        folder = directory == null ? this.getTmpFolderPath() : directory.getAbsolutePath();
        int counter = this.tmpFileCounter.getAndIncrement();
        String fileName = prefix + counter + suffix;
        String path = folder + File.separator + fileName;
        boolean created = this.createFile(path);
        if (!created) {
            throw new IOException();
        }
        return path;
    }

    private String getTmpFolderPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public boolean exists(String rawPath) {
        return this.findFSObject(rawPath) != null;
    }

    public FSObject findFSObject(String rawPath) {
        String path = new File(rawPath).getAbsolutePath();
        String[] tokens = this.tokenize(path);
        this.markAccessedFile(path);
        VFolder parent = this.root;
        for (int i = 0; i < tokens.length; ++i) {
            String name = tokens[i];
            FSObject child = parent.getChild(name);
            if (child == null || child.isDeleted()) {
                return null;
            }
            if (i < tokens.length - 1 && !child.isFolder()) {
                return null;
            }
            if (i == tokens.length - 1) {
                return child;
            }
            parent = (VFolder)child;
        }
        return parent;
    }

    public boolean deleteFSObject(String rawPath) {
        FSObject obj = this.findFSObject(rawPath);
        if (obj == null || !obj.isWritePermission()) {
            return false;
        }
        return obj.delete();
    }

    public boolean createFile(String rawPath) {
        return this.createFile(rawPath, false);
    }

    private boolean createFile(String rawPath, boolean tmp) {
        String parent = new File(rawPath).getParent();
        boolean created = this.createFolder(parent);
        if (!created) {
            return false;
        }
        VFolder folder = (VFolder)this.findFSObject(parent);
        VFile file = new VFile(rawPath, folder);
        folder.addChild(file);
        if (!tmp) {
            this.markAccessedFile(file.getPath());
        }
        return true;
    }

    public boolean rename(String source, String destination) {
        String parentSource = new File(source).getParent();
        String parentDest = new File(destination).getParent();
        if (parentSource == null && parentDest != null || !parentSource.equals(parentDest)) {
            return false;
        }
        FSObject src = this.findFSObject(source);
        if (src == null) {
            return false;
        }
        FSObject dest = this.findFSObject(destination);
        if (dest != null) {
            return false;
        }
        return src.rename(destination);
    }

    public boolean createFolder(String rawPath) {
        String[] tokens = this.tokenize(new File(rawPath).getAbsolutePath());
        VFolder parent = this.root;
        for (String name : tokens) {
            if (!parent.isReadPermission() || !parent.isWritePermission() || parent.isDeleted()) {
                return false;
            }
            VFolder folder = null;
            if (!parent.hasChild(name)) {
                String path = null;
                path = this.isUnixStyle() || !parent.isRoot() ? parent.getPath() + File.separator + name : name;
                folder = new VFolder(path, parent);
            } else {
                FSObject child = parent.getChild(name);
                if (!child.isFolder()) {
                    return false;
                }
                folder = (VFolder)child;
            }
            parent.addChild(folder);
            parent = folder;
        }
        this.markAccessedFile(parent.getPath());
        return true;
    }

    private String[] tokenize(String path) {
        return VirtualFileSystem.tokenize(path, File.separatorChar);
    }

    protected static String[] tokenize(String path, char separator) {
        String[] tokens = path.split(separator == '\\' ? "\\\\" : File.separator);
        ArrayList<String> list = new ArrayList<String>(tokens.length);
        for (String token : tokens) {
            if (token.isEmpty()) continue;
            list.add(token);
        }
        return list.toArray(new String[0]);
    }

    private boolean isUnixStyle() {
        return File.separator.equals("/");
    }
}

