/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.boot.model.process.internal;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.evosuite.shaded.org.hibernate.boot.MappingException;
import org.evosuite.shaded.org.hibernate.boot.archive.internal.StandardArchiveDescriptorFactory;
import org.evosuite.shaded.org.hibernate.boot.archive.internal.UrlInputStreamAccess;
import org.evosuite.shaded.org.hibernate.boot.archive.scan.internal.StandardScanParameters;
import org.evosuite.shaded.org.hibernate.boot.archive.scan.internal.StandardScanner;
import org.evosuite.shaded.org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.evosuite.shaded.org.hibernate.boot.archive.scan.spi.MappingFileDescriptor;
import org.evosuite.shaded.org.hibernate.boot.archive.scan.spi.PackageDescriptor;
import org.evosuite.shaded.org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.evosuite.shaded.org.hibernate.boot.archive.scan.spi.ScanResult;
import org.evosuite.shaded.org.hibernate.boot.archive.scan.spi.Scanner;
import org.evosuite.shaded.org.hibernate.boot.archive.spi.ArchiveDescriptorFactory;
import org.evosuite.shaded.org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.evosuite.shaded.org.hibernate.boot.jaxb.Origin;
import org.evosuite.shaded.org.hibernate.boot.jaxb.SourceType;
import org.evosuite.shaded.org.hibernate.boot.model.process.internal.ManagedResourcesImpl;
import org.evosuite.shaded.org.hibernate.boot.registry.StandardServiceRegistry;
import org.evosuite.shaded.org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.evosuite.shaded.org.hibernate.boot.spi.ClassLoaderAccess;
import org.evosuite.shaded.org.hibernate.boot.spi.MetadataBuildingOptions;
import org.evosuite.shaded.org.hibernate.boot.spi.XmlMappingBinderAccess;
import org.evosuite.shaded.org.hibernate.cfg.AttributeConverterDefinition;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class ScanningCoordinator {
    private static final Logger log = Logger.getLogger(ScanningCoordinator.class);
    public static final ScanningCoordinator INSTANCE = new ScanningCoordinator();
    private static final Class[] SINGLE_ARG = new Class[]{ArchiveDescriptorFactory.class};

    private ScanningCoordinator() {
    }

    public void coordinateScan(ManagedResourcesImpl managedResources, MetadataBuildingOptions options, XmlMappingBinderAccess xmlMappingBinderAccess) {
        if (options.getScanEnvironment() == null) {
            return;
        }
        ClassLoaderService classLoaderService = options.getServiceRegistry().getService(ClassLoaderService.class);
        ClassLoaderAccessImpl classLoaderAccess = new ClassLoaderAccessImpl(options.getTempClassLoader(), classLoaderService);
        Scanner scanner = ScanningCoordinator.buildScanner(options, classLoaderAccess);
        ScanResult scanResult = scanner.scan(options.getScanEnvironment(), options.getScanOptions(), StandardScanParameters.INSTANCE);
        this.applyScanResultsToManagedResources(managedResources, scanResult, options, xmlMappingBinderAccess);
    }

    private static Scanner buildScanner(MetadataBuildingOptions options, ClassLoaderAccess classLoaderAccess) {
        Object scannerSetting = options.getScanner();
        ArchiveDescriptorFactory archiveDescriptorFactory = options.getArchiveDescriptorFactory();
        if (scannerSetting == null) {
            if (archiveDescriptorFactory == null) {
                return new StandardScanner();
            }
            return new StandardScanner(archiveDescriptorFactory);
        }
        if (Scanner.class.isInstance(scannerSetting)) {
            if (archiveDescriptorFactory != null) {
                throw new IllegalStateException("A Scanner instance and an ArchiveDescriptorFactory were both specified; please specify one or the other, or if you need to supply both, Scanner class to use (assuming it has a constructor accepting a ArchiveDescriptorFactory).  Alternatively, just pass the ArchiveDescriptorFactory during your own Scanner constructor assuming it is statically known.");
            }
            return (Scanner)scannerSetting;
        }
        Class scannerImplClass = Class.class.isInstance(scannerSetting) ? (Class)scannerSetting : classLoaderAccess.classForName(scannerSetting.toString());
        if (archiveDescriptorFactory != null) {
            try {
                Constructor constructor = scannerImplClass.getConstructor(SINGLE_ARG);
                try {
                    return (Scanner)constructor.newInstance(archiveDescriptorFactory);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error trying to instantiate custom specified Scanner [" + scannerImplClass.getName() + "]", e);
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Configuration named a custom Scanner and a custom ArchiveDescriptorFactory, but Scanner impl did not define a constructor accepting ArchiveDescriptorFactory");
            }
        }
        try {
            Constructor constructor = scannerImplClass.getConstructor(SINGLE_ARG);
            try {
                return (Scanner)constructor.newInstance(StandardArchiveDescriptorFactory.INSTANCE);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error trying to instantiate custom specified Scanner [" + scannerImplClass.getName() + "]", e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor constructor = scannerImplClass.getConstructor(new Class[0]);
                try {
                    return (Scanner)constructor.newInstance(new Object[0]);
                }
                catch (Exception e2) {
                    throw new IllegalStateException("Error trying to instantiate custom specified Scanner [" + scannerImplClass.getName() + "]", e2);
                }
            }
            catch (NoSuchMethodException ignore) {
                throw new IllegalArgumentException("Configuration named a custom Scanner, but we were unable to locate an appropriate constructor");
            }
        }
    }

    public void applyScanResultsToManagedResources(ManagedResourcesImpl managedResources, ScanResult scanResult, MetadataBuildingOptions options, XmlMappingBinderAccess xmlMappingBinderAccess) {
        ScanEnvironment scanEnvironment = options.getScanEnvironment();
        StandardServiceRegistry serviceRegistry = options.getServiceRegistry();
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        HashSet<String> nonLocatedMappingFileNames = new HashSet<String>();
        List<String> explicitMappingFileNames = scanEnvironment.getExplicitlyListedMappingFiles();
        if (explicitMappingFileNames != null) {
            nonLocatedMappingFileNames.addAll(explicitMappingFileNames);
        }
        for (MappingFileDescriptor mappingFileDescriptor : scanResult.getLocatedMappingFiles()) {
            managedResources.addXmlBinding(xmlMappingBinderAccess.bind(mappingFileDescriptor.getStreamAccess()));
            nonLocatedMappingFileNames.remove(mappingFileDescriptor.getName());
        }
        for (String name : nonLocatedMappingFileNames) {
            URL url = classLoaderService.locateResource(name);
            if (url == null) {
                throw new MappingException("Unable to resolve explicitly named mapping-file : " + name, new Origin(SourceType.RESOURCE, name));
            }
            UrlInputStreamAccess inputStreamAccess = new UrlInputStreamAccess(url);
            managedResources.addXmlBinding(xmlMappingBinderAccess.bind(inputStreamAccess));
        }
        ArrayList unresolvedListedClassNames = scanEnvironment.getExplicitlyListedClassNames() == null ? new ArrayList() : new ArrayList<String>(scanEnvironment.getExplicitlyListedClassNames());
        for (ClassDescriptor classDescriptor : scanResult.getLocatedClasses()) {
            if (classDescriptor.getCategorization() == ClassDescriptor.Categorization.CONVERTER) {
                managedResources.addAttributeConverterDefinition(AttributeConverterDefinition.from(classLoaderService.classForName(classDescriptor.getName())));
            } else if (classDescriptor.getCategorization() == ClassDescriptor.Categorization.MODEL) {
                managedResources.addAnnotatedClassName(classDescriptor.getName());
            }
            unresolvedListedClassNames.remove(classDescriptor.getName());
        }
        for (PackageDescriptor packageDescriptor : scanResult.getLocatedPackages()) {
            managedResources.addAnnotatedPackageName(packageDescriptor.getName());
            unresolvedListedClassNames.remove(packageDescriptor.getName());
        }
        for (String unresolvedListedClassName : unresolvedListedClassNames) {
            String classFileName = unresolvedListedClassName.replace('.', '/') + ".class";
            URL classFileUrl = classLoaderService.locateResource(classFileName);
            if (classFileUrl != null) {
                managedResources.addAnnotatedClassName(unresolvedListedClassName);
                continue;
            }
            String packageInfoFileName = unresolvedListedClassName.replace('.', '/') + "/package-info.class";
            URL packageInfoFileUrl = classLoaderService.locateResource(packageInfoFileName);
            if (packageInfoFileUrl != null) {
                managedResources.addAnnotatedPackageName(unresolvedListedClassName);
                continue;
            }
            log.debugf("Unable to resolve class [%s] named in persistence unit [%s]", (Object)unresolvedListedClassName, (Object)scanEnvironment.getRootUrl());
        }
    }
}

