/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.boot.registry.selector.internal;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.shaded.org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.evosuite.shaded.org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.evosuite.shaded.org.hibernate.boot.registry.selector.spi.StrategyCreator;
import org.evosuite.shaded.org.hibernate.boot.registry.selector.spi.StrategySelectionException;
import org.evosuite.shaded.org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class StrategySelectorImpl
implements StrategySelector {
    private static final Logger log = Logger.getLogger(StrategySelectorImpl.class);
    public static StrategyCreator STANDARD_STRATEGY_CREATOR = strategyClass -> {
        try {
            return strategyClass.newInstance();
        }
        catch (Exception e) {
            throw new StrategySelectionException(String.format("Could not instantiate named strategy class [%s]", strategyClass.getName()), e);
        }
    };
    private final Map<Class, Map<String, Class>> namedStrategyImplementorByStrategyMap = new ConcurrentHashMap<Class, Map<String, Class>>();
    private final ClassLoaderService classLoaderService;

    public StrategySelectorImpl(ClassLoaderService classLoaderService) {
        this.classLoaderService = classLoaderService;
    }

    @Override
    public <T> void registerStrategyImplementor(Class<T> strategy, String name, Class<? extends T> implementation) {
        Class<T> old;
        Map<String, Class> namedStrategyImplementorMap = this.namedStrategyImplementorByStrategyMap.get(strategy);
        if (namedStrategyImplementorMap == null) {
            namedStrategyImplementorMap = new ConcurrentHashMap<String, Class>();
            this.namedStrategyImplementorByStrategyMap.put(strategy, namedStrategyImplementorMap);
        }
        if ((old = namedStrategyImplementorMap.put(name, implementation)) == null) {
            log.trace(String.format("Registering named strategy selector [%s] : [%s] -> [%s]", strategy.getName(), name, implementation.getName()));
        } else {
            log.debug(String.format("Registering named strategy selector [%s] : [%s] -> [%s] (replacing [%s])", strategy.getName(), name, implementation.getName(), old.getName()));
        }
    }

    @Override
    public <T> void unRegisterStrategyImplementor(Class<T> strategy, Class<? extends T> implementation) {
        Map<String, Class> namedStrategyImplementorMap = this.namedStrategyImplementorByStrategyMap.get(strategy);
        if (namedStrategyImplementorMap == null) {
            log.debug("Named strategy map did not exist on call to un-register");
            return;
        }
        Iterator<Class> itr = namedStrategyImplementorMap.values().iterator();
        while (itr.hasNext()) {
            Class registered = itr.next();
            if (!registered.equals(implementation)) continue;
            itr.remove();
        }
        if (namedStrategyImplementorMap.isEmpty()) {
            this.namedStrategyImplementorByStrategyMap.remove(strategy);
        }
    }

    @Override
    public <T> Class<? extends T> selectStrategyImplementor(Class<T> strategy, String name) {
        Class registered;
        Map<String, Class> namedStrategyImplementorMap = this.namedStrategyImplementorByStrategyMap.get(strategy);
        if (namedStrategyImplementorMap != null && (registered = namedStrategyImplementorMap.get(name)) != null) {
            return registered;
        }
        try {
            return this.classLoaderService.classForName(name);
        }
        catch (ClassLoadingException e) {
            throw new StrategySelectionException("Unable to resolve name [" + name + "] as strategy [" + strategy.getName() + "]");
        }
    }

    @Override
    public <T> T resolveStrategy(Class<T> strategy, Object strategyReference) {
        return this.resolveDefaultableStrategy(strategy, strategyReference, (T)null);
    }

    @Override
    public <T> T resolveDefaultableStrategy(Class<T> strategy, Object strategyReference, T defaultValue) {
        return (T)this.resolveDefaultableStrategy(strategy, strategyReference, () -> defaultValue);
    }

    @Override
    public <T> T resolveDefaultableStrategy(Class<T> strategy, Object strategyReference, Callable<T> defaultResolver) {
        return this.resolveStrategy(strategy, strategyReference, defaultResolver, STANDARD_STRATEGY_CREATOR);
    }

    @Override
    public <T> T resolveStrategy(Class<T> strategy, Object strategyReference, T defaultValue, StrategyCreator<T> creator) {
        return (T)this.resolveStrategy(strategy, strategyReference, () -> defaultValue, creator);
    }

    @Override
    public <T> T resolveStrategy(Class<T> strategy, Object strategyReference, Callable<T> defaultResolver, StrategyCreator<T> creator) {
        if (strategyReference == null) {
            try {
                return defaultResolver.call();
            }
            catch (Exception e) {
                throw new StrategySelectionException("Default-resolver threw exception", e);
            }
        }
        if (strategy.isInstance(strategyReference)) {
            return strategy.cast(strategyReference);
        }
        Class<T> implementationClass = Class.class.isInstance(strategyReference) ? (Class<T>)strategyReference : this.selectStrategyImplementor(strategy, strategyReference.toString());
        try {
            return creator.create(implementationClass);
        }
        catch (Exception e) {
            throw new StrategySelectionException(String.format("Could not instantiate named strategy class [%s]", implementationClass.getName()), e);
        }
    }
}

