/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.persistence.Embedded;
import org.evosuite.shaded.net.bytebuddy.asm.Advice;
import org.evosuite.shaded.net.bytebuddy.asm.AsmVisitorWrapper;
import org.evosuite.shaded.net.bytebuddy.description.field.FieldDescription;
import org.evosuite.shaded.net.bytebuddy.description.method.MethodDescription;
import org.evosuite.shaded.net.bytebuddy.description.modifier.Visibility;
import org.evosuite.shaded.net.bytebuddy.description.type.TypeDefinition;
import org.evosuite.shaded.net.bytebuddy.description.type.TypeDescription;
import org.evosuite.shaded.net.bytebuddy.dynamic.DynamicType;
import org.evosuite.shaded.net.bytebuddy.implementation.FieldAccessor;
import org.evosuite.shaded.net.bytebuddy.implementation.Implementation;
import org.evosuite.shaded.net.bytebuddy.implementation.StubMethod;
import org.evosuite.shaded.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.evosuite.shaded.net.bytebuddy.jar.asm.MethodVisitor;
import org.evosuite.shaded.net.bytebuddy.matcher.ElementMatchers;
import org.evosuite.shaded.net.bytebuddy.pool.TypePool;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy.BiDirectionalAssociationHandler;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy.ByteBuddyEnhancementContext;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy.CodeTemplates;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerImpl;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy.FieldAccessEnhancer;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy.FieldReaderAppender;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy.FieldWriterAppender;
import org.evosuite.shaded.org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckingHandler;
import org.evosuite.shaded.org.hibernate.engine.spi.CompositeOwner;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;

class PersistentAttributeTransformer
implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(PersistentAttributeTransformer.class);
    private final TypeDescription managedCtClass;
    private final ByteBuddyEnhancementContext enhancementContext;
    private final TypePool classPool;
    private final FieldDescription[] enhancedFields;

    private PersistentAttributeTransformer(TypeDescription managedCtClass, ByteBuddyEnhancementContext enhancementContext, TypePool classPool, FieldDescription[] enhancedFields) {
        this.managedCtClass = managedCtClass;
        this.enhancementContext = enhancementContext;
        this.classPool = classPool;
        this.enhancedFields = enhancedFields;
    }

    public static PersistentAttributeTransformer collectPersistentFields(TypeDescription managedCtClass, ByteBuddyEnhancementContext enhancementContext, TypePool classPool) {
        ArrayList<FieldDescription> persistentFieldList = new ArrayList<FieldDescription>();
        for (FieldDescription fieldDescription : managedCtClass.getDeclaredFields()) {
            if (fieldDescription.getName().startsWith("$$_hibernate_") || "this$0".equals(fieldDescription.getName()) || fieldDescription.isStatic() || !enhancementContext.isPersistentField(fieldDescription)) continue;
            persistentFieldList.add(fieldDescription);
        }
        if (!enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            persistentFieldList.addAll(PersistentAttributeTransformer.collectInheritPersistentFields(managedCtClass, enhancementContext));
        }
        Object[] orderedFields = enhancementContext.order(persistentFieldList.toArray(new FieldDescription[0]));
        log.debugf("Persistent fields for entity %s: %s", (Object)managedCtClass.getName(), (Object)Arrays.toString(orderedFields));
        return new PersistentAttributeTransformer(managedCtClass, enhancementContext, classPool, (FieldDescription[])orderedFields);
    }

    private static Collection<FieldDescription> collectInheritPersistentFields(TypeDefinition managedCtClass, ByteBuddyEnhancementContext enhancementContext) {
        if (managedCtClass == null || managedCtClass.represents((Type)((Object)Object.class))) {
            return Collections.emptyList();
        }
        TypeDescription.Generic managedCtSuperclass = managedCtClass.getSuperClass();
        if (!enhancementContext.isMappedSuperclassClass(managedCtSuperclass.asErasure())) {
            return PersistentAttributeTransformer.collectInheritPersistentFields(managedCtSuperclass, enhancementContext);
        }
        log.debugf("Found @MappedSuperclass %s to collectPersistenceFields", (Object)managedCtSuperclass);
        ArrayList<FieldDescription> persistentFieldList = new ArrayList<FieldDescription>();
        for (FieldDescription ctField : managedCtSuperclass.getDeclaredFields()) {
            if (ctField.getName().startsWith("$$_hibernate_") || "this$0".equals(ctField.getName()) || ctField.isStatic() || !enhancementContext.isPersistentField(ctField)) continue;
            persistentFieldList.add(ctField);
        }
        persistentFieldList.addAll(PersistentAttributeTransformer.collectInheritPersistentFields(managedCtSuperclass, enhancementContext));
        return persistentFieldList;
    }

    @Override
    public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, final MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
        return new MethodVisitor(327680, methodVisitor){

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (PersistentAttributeTransformer.this.isEnhanced(owner, name, desc)) {
                    switch (opcode) {
                        case 180: {
                            methodVisitor.visitMethodInsn(182, owner, "$$_hibernate_read_" + name, "()" + desc, false);
                            return;
                        }
                        case 181: {
                            methodVisitor.visitMethodInsn(182, owner, "$$_hibernate_write_" + name, "(" + desc + ")V", false);
                            return;
                        }
                    }
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        };
    }

    private boolean isEnhanced(String owner, String name, String desc) {
        for (FieldDescription enhancedField : this.enhancedFields) {
            if (!enhancedField.getName().equals(name) || !enhancedField.getDescriptor().equals(desc) || !enhancedField.getDeclaringType().asErasure().getInternalName().equals(owner)) continue;
            return true;
        }
        return false;
    }

    DynamicType.Builder<?> applyTo(DynamicType.Builder<?> builder, boolean accessor) {
        boolean compositeOwner = false;
        builder = builder.visit(new AsmVisitorWrapper.ForDeclaredMethods().method(ElementMatchers.not(ElementMatchers.nameStartsWith("$$_hibernate_")), this));
        for (FieldDescription enhancedField : this.enhancedFields) {
            builder = builder.defineMethod("$$_hibernate_read_" + enhancedField.getName(), (TypeDefinition)enhancedField.getType().asErasure(), Visibility.PUBLIC).intercept(accessor ? FieldAccessor.ofField(enhancedField.getName()).in(enhancedField.getDeclaringType().asErasure()) : this.fieldReader(enhancedField)).defineMethod("$$_hibernate_write_" + enhancedField.getName(), (TypeDefinition)TypeDescription.VOID, Visibility.PUBLIC).withParameters(enhancedField.getType().asErasure()).intercept(accessor ? FieldAccessor.ofField(enhancedField.getName()).in(enhancedField.getDeclaringType().asErasure()) : this.fieldWriter(enhancedField));
            if (compositeOwner || accessor || !EnhancerImpl.isAnnotationPresent(enhancedField, Embedded.class) || !this.enhancementContext.isCompositeClass(enhancedField.getType().asErasure()) || !this.enhancementContext.doDirtyCheckingInline(this.managedCtClass)) continue;
            compositeOwner = true;
        }
        if (compositeOwner) {
            builder = builder.implement(new Type[]{CompositeOwner.class});
            if (this.enhancementContext.isCompositeClass(this.managedCtClass)) {
                builder = builder.defineMethod("$$_hibernate_trackChange", Void.TYPE, Visibility.PUBLIC).withParameters(new Type[]{String.class}).intercept(Advice.to(CodeTemplates.CompositeOwnerDirtyCheckingHandler.class).wrap(StubMethod.INSTANCE));
            }
        }
        if (this.enhancementContext.doExtendedEnhancement(this.managedCtClass)) {
            builder = this.applyExtended(builder);
        }
        return builder;
    }

    private Implementation fieldReader(FieldDescription enhancedField) {
        if (!this.enhancementContext.hasLazyLoadableAttributes(this.managedCtClass) || !this.enhancementContext.isLazyLoadable(enhancedField)) {
            if (enhancedField.getDeclaringType().asErasure().equals(this.managedCtClass)) {
                return FieldAccessor.ofField(enhancedField.getName()).in(enhancedField.getDeclaringType().asErasure());
            }
            return new Implementation.Simple(new FieldMethodReader(this.managedCtClass, enhancedField));
        }
        return new Implementation.Simple(FieldReaderAppender.of(this.managedCtClass, enhancedField));
    }

    private Implementation fieldWriter(FieldDescription enhancedField) {
        Implementation implementation = !this.enhancementContext.hasLazyLoadableAttributes(this.managedCtClass) || !this.enhancementContext.isLazyLoadable(enhancedField) ? (enhancedField.getDeclaringType().asErasure().equals(this.managedCtClass) ? FieldAccessor.ofField(enhancedField.getName()).in(enhancedField.getDeclaringType().asErasure()) : new Implementation.Simple(new FieldMethodWriter(this.managedCtClass, enhancedField))) : new Implementation.Simple(FieldWriterAppender.of(this.managedCtClass, enhancedField));
        implementation = InlineDirtyCheckingHandler.wrap(this.managedCtClass, this.enhancementContext, enhancedField, implementation);
        return BiDirectionalAssociationHandler.wrap(this.managedCtClass, this.enhancementContext, enhancedField, implementation);
    }

    DynamicType.Builder<?> applyExtended(DynamicType.Builder<?> builder) {
        FieldAccessEnhancer enhancer = new FieldAccessEnhancer(this.managedCtClass, this.enhancementContext, this.classPool);
        return builder.visit(new AsmVisitorWrapper.ForDeclaredMethods().method(ElementMatchers.not(ElementMatchers.nameStartsWith("$$_hibernate_")), enhancer));
    }

    private static class FieldMethodWriter
    implements ByteCodeAppender {
        private final TypeDescription managedCtClass;
        private final FieldDescription persistentField;

        private FieldMethodWriter(TypeDescription managedCtClass, FieldDescription persistentField) {
            this.managedCtClass = managedCtClass;
            this.persistentField = persistentField;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(org.evosuite.shaded.net.bytebuddy.jar.asm.Type.getType(this.persistentField.getType().asErasure().getDescriptor()).getOpcode(21), 1);
            methodVisitor.visitMethodInsn(183, this.managedCtClass.getSuperClass().asErasure().getInternalName(), "$$_hibernate_write_" + this.persistentField.getName(), org.evosuite.shaded.net.bytebuddy.jar.asm.Type.getMethodDescriptor(org.evosuite.shaded.net.bytebuddy.jar.asm.Type.getType(Void.TYPE), org.evosuite.shaded.net.bytebuddy.jar.asm.Type.getType(this.persistentField.getType().asErasure().getDescriptor())), false);
            methodVisitor.visitInsn(177);
            return new ByteCodeAppender.Size(1 + this.persistentField.getType().getStackSize().getSize(), instrumentedMethod.getStackSize());
        }
    }

    private static class FieldMethodReader
    implements ByteCodeAppender {
        private final TypeDescription managedCtClass;
        private final FieldDescription persistentField;

        private FieldMethodReader(TypeDescription managedCtClass, FieldDescription persistentField) {
            this.managedCtClass = managedCtClass;
            this.persistentField = persistentField;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, this.managedCtClass.getSuperClass().asErasure().getInternalName(), "$$_hibernate_read_" + this.persistentField.getName(), org.evosuite.shaded.net.bytebuddy.jar.asm.Type.getMethodDescriptor(org.evosuite.shaded.net.bytebuddy.jar.asm.Type.getType(this.persistentField.getType().asErasure().getDescriptor()), new org.evosuite.shaded.net.bytebuddy.jar.asm.Type[0]), false);
            methodVisitor.visitInsn(org.evosuite.shaded.net.bytebuddy.jar.asm.Type.getType(this.persistentField.getType().asErasure().getDescriptor()).getOpcode(172));
            return new ByteCodeAppender.Size(this.persistentField.getType().getStackSize().getSize(), instrumentedMethod.getStackSize());
        }
    }
}

