/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.event.internal;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.LockMode;
import org.evosuite.shaded.org.hibernate.engine.internal.Versioning;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityKey;
import org.evosuite.shaded.org.hibernate.engine.spi.Status;
import org.evosuite.shaded.org.hibernate.event.internal.OnLockVisitor;
import org.evosuite.shaded.org.hibernate.event.spi.AbstractEvent;
import org.evosuite.shaded.org.hibernate.event.spi.EventSource;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.pretty.MessageHelper;
import org.evosuite.shaded.org.hibernate.type.TypeHelper;
import org.evosuite.shaded.org.jboss.logging.Logger;

public abstract class AbstractReassociateEventListener
implements Serializable {
    private static final Logger log = CoreLogging.logger(AbstractReassociateEventListener.class);

    protected final EntityEntry reassociate(AbstractEvent event, Object object, Serializable id, EntityPersister persister) {
        if (log.isTraceEnabled()) {
            log.tracev("Reassociating transient instance: {0}", (Object)MessageHelper.infoString(persister, id, event.getSession().getFactory()));
        }
        EventSource source = event.getSession();
        EntityKey key = source.generateEntityKey(id, persister);
        source.getPersistenceContext().checkUniqueness(key, object);
        Object[] values = persister.getPropertyValues(object);
        TypeHelper.deepCopy(values, persister.getPropertyTypes(), persister.getPropertyUpdateability(), values, source);
        Object version = Versioning.getVersion(values, persister);
        EntityEntry newEntry = source.getPersistenceContext().addEntity(object, persister.isMutable() ? Status.MANAGED : Status.READ_ONLY, values, key, version, LockMode.NONE, true, persister, false);
        new OnLockVisitor(source, id, object).process(object, persister);
        persister.afterReassociate(object, source);
        return newEntry;
    }
}

