/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.event.internal;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.evosuite.shaded.org.hibernate.cache.spi.entry.CollectionCacheEntry;
import org.evosuite.shaded.org.hibernate.collection.spi.PersistentCollection;
import org.evosuite.shaded.org.hibernate.engine.internal.CacheHelper;
import org.evosuite.shaded.org.hibernate.engine.spi.CollectionEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.PersistenceContext;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.event.spi.EventSource;
import org.evosuite.shaded.org.hibernate.event.spi.InitializeCollectionEvent;
import org.evosuite.shaded.org.hibernate.event.spi.InitializeCollectionEventListener;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.persister.collection.CollectionPersister;
import org.evosuite.shaded.org.hibernate.pretty.MessageHelper;

public class DefaultInitializeCollectionEventListener
implements InitializeCollectionEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultInitializeCollectionEventListener.class);

    @Override
    public void onInitializeCollection(InitializeCollectionEvent event) throws HibernateException {
        PersistentCollection collection = event.getCollection();
        EventSource source = event.getSession();
        CollectionEntry ce = source.getPersistenceContext().getCollectionEntry(collection);
        if (ce == null) {
            throw new HibernateException("collection was evicted");
        }
        if (!collection.wasInitialized()) {
            boolean foundInCache;
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Initializing collection {0}", (Object)MessageHelper.collectionInfoString(ce.getLoadedPersister(), collection, ce.getLoadedKey(), source));
                LOG.trace("Checking second-level cache");
            }
            if (foundInCache = this.initializeCollectionFromCache(ce.getLoadedKey(), ce.getLoadedPersister(), collection, source)) {
                if (traceEnabled) {
                    LOG.trace("Collection initialized from cache");
                }
            } else {
                if (traceEnabled) {
                    LOG.trace("Collection not cached");
                }
                ce.getLoadedPersister().initialize(ce.getLoadedKey(), source);
                if (traceEnabled) {
                    LOG.trace("Collection initialized");
                }
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatisticsImplementor().fetchCollection(ce.getLoadedPersister().getRole());
                }
            }
        }
    }

    private boolean initializeCollectionFromCache(Serializable id, CollectionPersister persister, PersistentCollection collection, SessionImplementor source) {
        boolean useCache;
        if (!source.getLoadQueryInfluencers().getEnabledFilters().isEmpty() && persister.isAffectedByEnabledFilters(source)) {
            LOG.trace("Disregarding cached version (if any) of collection due to enabled filters");
            return false;
        }
        boolean bl = useCache = persister.hasCache() && source.getCacheMode().isGetEnabled();
        if (!useCache) {
            return false;
        }
        SessionFactoryImplementor factory = source.getFactory();
        CollectionRegionAccessStrategy cacheAccessStrategy = persister.getCacheAccessStrategy();
        Object ck = cacheAccessStrategy.generateCacheKey(id, persister, factory, source.getTenantIdentifier());
        Serializable ce = CacheHelper.fromSharedCache(source, ck, persister.getCacheAccessStrategy());
        if (factory.getStatistics().isStatisticsEnabled()) {
            if (ce == null) {
                factory.getStatisticsImplementor().secondLevelCacheMiss(cacheAccessStrategy.getRegion().getName());
            } else {
                factory.getStatisticsImplementor().secondLevelCacheHit(cacheAccessStrategy.getRegion().getName());
            }
        }
        if (ce == null) {
            return false;
        }
        CollectionCacheEntry cacheEntry = (CollectionCacheEntry)persister.getCacheEntryStructure().destructure(ce, factory);
        PersistenceContext persistenceContext = source.getPersistenceContext();
        cacheEntry.assemble(collection, persister, persistenceContext.getCollectionOwner(id, persister));
        persistenceContext.getCollectionEntry(collection).postInitialize(collection);
        return true;
    }
}

