/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.hql.internal.ast.tree;

import org.evosuite.shaded.antlr.SemanticException;
import org.evosuite.shaded.antlr.collections.AST;
import org.evosuite.shaded.org.hibernate.dialect.function.SQLFunction;
import org.evosuite.shaded.org.hibernate.dialect.function.StandardSQLFunction;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.AbstractSelectExpression;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.FunctionNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.SelectExpression;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.SqlNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.util.ColumnHelper;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.type.Type;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class AggregateNode
extends AbstractSelectExpression
implements SelectExpression,
FunctionNode {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AggregateNode.class.getName());
    private SQLFunction sqlFunction;

    @Override
    public SQLFunction getSQLFunction() {
        return this.sqlFunction;
    }

    public void resolve() {
        this.resolveFunction();
    }

    private SQLFunction resolveFunction() {
        if (this.sqlFunction == null) {
            String name = this.getText();
            this.sqlFunction = this.getSessionFactoryHelper().findSQLFunction(this.getText());
            if (this.sqlFunction == null) {
                LOG.unableToResolveAggregateFunction(name);
                this.sqlFunction = new StandardSQLFunction(name);
            }
        }
        return this.sqlFunction;
    }

    @Override
    public Type getFirstArgumentType() {
        AST argument = this.getFirstChild();
        while (argument != null) {
            if (!(argument instanceof SqlNode)) continue;
            Type type = ((SqlNode)argument).getDataType();
            if (type != null) {
                return type;
            }
            argument = argument.getNextSibling();
        }
        return null;
    }

    @Override
    public Type getDataType() {
        return this.getSessionFactoryHelper().findFunctionReturnType(this.getText(), this.resolveFunction(), this.getFirstChild());
    }

    @Override
    public void setScalarColumnText(int i) throws SemanticException {
        ColumnHelper.generateSingleScalarColumn(this, i);
    }

    @Override
    public boolean isScalar() throws SemanticException {
        return true;
    }
}

