/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.internal.util.compare;

import java.util.Arrays;

public final class EqualsHelper {
    public static boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public static boolean areEqual(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.equals(y)) {
            return true;
        }
        Class<?> xClass = x.getClass();
        Class<?> yClass = y.getClass();
        if (xClass.isArray() && yClass.isArray()) {
            if (xClass.equals(yClass)) {
                if (x instanceof boolean[]) {
                    return Arrays.equals((boolean[])x, (boolean[])y);
                }
                if (x instanceof byte[]) {
                    return Arrays.equals((byte[])x, (byte[])y);
                }
                if (x instanceof char[]) {
                    return Arrays.equals((char[])x, (char[])y);
                }
                if (x instanceof short[]) {
                    return Arrays.equals((short[])x, (short[])y);
                }
                if (x instanceof int[]) {
                    return Arrays.equals((int[])x, (int[])y);
                }
                if (x instanceof long[]) {
                    return Arrays.equals((long[])x, (long[])y);
                }
                if (x instanceof double[]) {
                    return Arrays.equals((double[])x, (double[])y);
                }
                if (x instanceof float[]) {
                    return Arrays.equals((float[])x, (float[])y);
                }
            }
            return Arrays.equals((Object[])x, (Object[])y);
        }
        return false;
    }

    private EqualsHelper() {
    }
}

