/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.loader.entity;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.LockOptions;
import org.evosuite.shaded.org.hibernate.engine.spi.LoadQueryInfluencers;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.evosuite.shaded.org.hibernate.loader.OuterJoinLoader;
import org.evosuite.shaded.org.hibernate.loader.entity.UniqueEntityLoader;
import org.evosuite.shaded.org.hibernate.persister.entity.OuterJoinLoadable;
import org.evosuite.shaded.org.hibernate.transform.ResultTransformer;
import org.evosuite.shaded.org.hibernate.type.Type;

public abstract class AbstractEntityLoader
extends OuterJoinLoader
implements UniqueEntityLoader {
    protected final OuterJoinLoadable persister;
    protected final Type uniqueKeyType;
    protected final String entityName;

    public AbstractEntityLoader(OuterJoinLoadable persister, Type uniqueKeyType, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
        super(factory, loadQueryInfluencers);
        this.uniqueKeyType = uniqueKeyType;
        this.entityName = persister.getEntityName();
        this.persister = persister;
    }

    @Override
    public Object load(Serializable id, Object optionalObject, SharedSessionContractImplementor session) {
        return this.load(id, optionalObject, session, LockOptions.NONE);
    }

    @Override
    public Object load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions) {
        return this.load(session, id, optionalObject, id, lockOptions);
    }

    protected Object load(SharedSessionContractImplementor session, Object id, Object optionalObject, Serializable optionalId, LockOptions lockOptions) {
        List list = this.loadEntity(session, id, this.uniqueKeyType, optionalObject, this.entityName, optionalId, this.persister, lockOptions);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 0) {
            return null;
        }
        if (this.getCollectionOwners() != null) {
            return list.get(0);
        }
        throw new HibernateException("More than one row with the given identifier was found: " + id + ", for class: " + this.persister.getEntityName());
    }

    @Override
    protected Object getResultColumnOrRow(Object[] row, ResultTransformer transformer, ResultSet rs, SharedSessionContractImplementor session) throws SQLException, HibernateException {
        return row[row.length - 1];
    }

    @Override
    protected boolean isSingleRowLoader() {
        return true;
    }
}

