/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.loader.entity;

import java.util.Collections;
import org.evosuite.shaded.org.hibernate.FetchMode;
import org.evosuite.shaded.org.hibernate.LockOptions;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.engine.spi.CascadeStyle;
import org.evosuite.shaded.org.hibernate.engine.spi.CascadingAction;
import org.evosuite.shaded.org.hibernate.engine.spi.LoadQueryInfluencers;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.loader.AbstractEntityJoinWalker;
import org.evosuite.shaded.org.hibernate.persister.entity.OuterJoinLoadable;
import org.evosuite.shaded.org.hibernate.type.AssociationType;

public class CascadeEntityJoinWalker
extends AbstractEntityJoinWalker {
    private final CascadingAction cascadeAction;

    public CascadeEntityJoinWalker(OuterJoinLoadable persister, CascadingAction action, SessionFactoryImplementor factory) throws MappingException {
        super(persister, factory, LoadQueryInfluencers.NONE);
        this.cascadeAction = action;
        StringBuilder whereCondition = this.whereString(this.getAlias(), persister.getIdentifierColumnNames(), 1).append(persister.filterFragment(this.getAlias(), Collections.EMPTY_MAP));
        this.initAll(whereCondition.toString(), "", LockOptions.READ);
    }

    @Override
    protected boolean isJoinedFetchEnabled(AssociationType type, FetchMode config, CascadeStyle cascadeStyle) {
        return !(!type.isEntityType() && !type.isCollectionType() || cascadeStyle != null && !cascadeStyle.doCascade(this.cascadeAction));
    }

    @Override
    protected boolean isTooManyCollections() {
        return CascadeEntityJoinWalker.countCollectionPersisters(this.associations) > 0;
    }

    @Override
    public String getComment() {
        return "load " + this.getPersister().getEntityName();
    }
}

