/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.mapping;

import java.util.Iterator;
import org.evosuite.shaded.org.hibernate.FetchMode;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.boot.spi.MetadataImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.Mapping;
import org.evosuite.shaded.org.hibernate.mapping.PersistentClass;
import org.evosuite.shaded.org.hibernate.mapping.Selectable;
import org.evosuite.shaded.org.hibernate.mapping.Table;
import org.evosuite.shaded.org.hibernate.mapping.Value;
import org.evosuite.shaded.org.hibernate.mapping.ValueVisitor;
import org.evosuite.shaded.org.hibernate.service.ServiceRegistry;
import org.evosuite.shaded.org.hibernate.type.EntityType;
import org.evosuite.shaded.org.hibernate.type.Type;

public class OneToMany
implements Value {
    private final MetadataImplementor metadata;
    private final Table referencingTable;
    private String referencedEntityName;
    private PersistentClass associatedClass;
    private boolean embedded;
    private boolean ignoreNotFound;

    public OneToMany(MetadataImplementor metadata, PersistentClass owner) throws MappingException {
        this.metadata = metadata;
        this.referencingTable = owner == null ? null : owner.getTable();
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.metadata.getMetadataBuildingOptions().getServiceRegistry();
    }

    private EntityType getEntityType() {
        return this.metadata.getTypeResolver().getTypeFactory().manyToOne(this.getReferencedEntityName(), true, null, false, false, this.isIgnoreNotFound(), false);
    }

    public PersistentClass getAssociatedClass() {
        return this.associatedClass;
    }

    public void setAssociatedClass(PersistentClass associatedClass) {
        this.associatedClass = associatedClass;
    }

    @Override
    public void createForeignKey() {
    }

    @Override
    public Iterator<Selectable> getColumnIterator() {
        return this.associatedClass.getKey().getColumnIterator();
    }

    @Override
    public int getColumnSpan() {
        return this.associatedClass.getKey().getColumnSpan();
    }

    @Override
    public FetchMode getFetchMode() {
        return FetchMode.JOIN;
    }

    @Override
    public Table getTable() {
        return this.referencingTable;
    }

    @Override
    public Type getType() {
        return this.getEntityType();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSimpleValue() {
        return false;
    }

    @Override
    public boolean isAlternateUniqueKey() {
        return false;
    }

    @Override
    public boolean hasFormula() {
        return false;
    }

    @Override
    public boolean isValid(Mapping mapping) throws MappingException {
        if (this.referencedEntityName == null) {
            throw new MappingException("one to many association must specify the referenced entity");
        }
        return true;
    }

    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName == null ? null : referencedEntityName.intern();
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) {
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean[] getColumnInsertability() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] getColumnUpdateability() {
        throw new UnsupportedOperationException();
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }
}

