/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.sql.ordering.antlr;

import org.evosuite.shaded.antlr.collections.AST;
import org.evosuite.shaded.org.hibernate.NullPrecedence;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.util.ASTPrinter;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.sql.ordering.antlr.GeneratedOrderByFragmentRenderer;
import org.evosuite.shaded.org.hibernate.sql.ordering.antlr.GeneratedOrderByFragmentRendererTokenTypes;
import org.evosuite.shaded.org.hibernate.sql.ordering.antlr.Node;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class OrderByFragmentRenderer
extends GeneratedOrderByFragmentRenderer {
    private static final Logger LOG = Logger.getLogger(OrderByFragmentRenderer.class.getName());
    private static final ASTPrinter printer = new ASTPrinter(GeneratedOrderByFragmentRendererTokenTypes.class);
    private final SessionFactoryImplementor sessionFactory;
    private int traceDepth = 0;

    public OrderByFragmentRenderer(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    protected void out(AST ast) {
        this.out(((Node)((Object)ast)).getRenderableText());
    }

    @Override
    public void traceIn(String ruleName, AST tree) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String prefix = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
        String traceText = ruleName + " (" + this.buildTraceNodeName(tree) + ")";
        LOG.trace(prefix + traceText);
    }

    private String buildTraceNodeName(AST tree) {
        return tree == null ? "???" : tree.getText() + " [" + printer.getTokenTypeName(tree.getType()) + "]";
    }

    @Override
    public void traceOut(String ruleName, AST tree) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String prefix = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
        LOG.trace(prefix + ruleName);
    }

    @Override
    protected String renderOrderByElement(String expression, String collation, String order, String nulls) {
        NullPrecedence nullPrecedence = NullPrecedence.parse(nulls, this.sessionFactory.getSessionFactoryOptions().getDefaultNullPrecedence());
        return this.sessionFactory.getDialect().renderOrderByElement(expression, collation, order, nullPrecedence);
    }
}

