/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.tool.schema.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.evosuite.shaded.org.hibernate.boot.Metadata;
import org.evosuite.shaded.org.hibernate.boot.model.naming.Identifier;
import org.evosuite.shaded.org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.evosuite.shaded.org.hibernate.boot.model.relational.Database;
import org.evosuite.shaded.org.hibernate.boot.model.relational.Exportable;
import org.evosuite.shaded.org.hibernate.boot.model.relational.Namespace;
import org.evosuite.shaded.org.hibernate.boot.model.relational.Sequence;
import org.evosuite.shaded.org.hibernate.boot.spi.MetadataImplementor;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.config.spi.ConfigurationService;
import org.evosuite.shaded.org.hibernate.engine.config.spi.StandardConverters;
import org.evosuite.shaded.org.hibernate.engine.jdbc.internal.FormatStyle;
import org.evosuite.shaded.org.hibernate.engine.jdbc.internal.Formatter;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.mapping.Constraint;
import org.evosuite.shaded.org.hibernate.mapping.ForeignKey;
import org.evosuite.shaded.org.hibernate.mapping.Index;
import org.evosuite.shaded.org.hibernate.mapping.Table;
import org.evosuite.shaded.org.hibernate.mapping.UniqueKey;
import org.evosuite.shaded.org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.evosuite.shaded.org.hibernate.tool.hbm2ddl.UniqueConstraintSchemaUpdateStrategy;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.spi.ForeignKeyInformation;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.spi.IndexInformation;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.spi.NameSpaceTablesInformation;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.evosuite.shaded.org.hibernate.tool.schema.extract.spi.TableInformation;
import org.evosuite.shaded.org.hibernate.tool.schema.internal.DefaultSchemaFilter;
import org.evosuite.shaded.org.hibernate.tool.schema.internal.Helper;
import org.evosuite.shaded.org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.evosuite.shaded.org.hibernate.tool.schema.internal.IndividuallySchemaMigratorImpl;
import org.evosuite.shaded.org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.evosuite.shaded.org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.evosuite.shaded.org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.evosuite.shaded.org.hibernate.tool.schema.spi.ExecutionOptions;
import org.evosuite.shaded.org.hibernate.tool.schema.spi.Exporter;
import org.evosuite.shaded.org.hibernate.tool.schema.spi.SchemaFilter;
import org.evosuite.shaded.org.hibernate.tool.schema.spi.SchemaManagementException;
import org.evosuite.shaded.org.hibernate.tool.schema.spi.SchemaMigrator;
import org.evosuite.shaded.org.hibernate.tool.schema.spi.TargetDescriptor;
import org.evosuite.shaded.org.jboss.logging.Logger;

public abstract class AbstractSchemaMigrator
implements SchemaMigrator {
    private static final Logger log = Logger.getLogger(IndividuallySchemaMigratorImpl.class);
    protected HibernateSchemaManagementTool tool;
    protected SchemaFilter schemaFilter;
    private UniqueConstraintSchemaUpdateStrategy uniqueConstraintStrategy;

    public AbstractSchemaMigrator(HibernateSchemaManagementTool tool, SchemaFilter schemaFilter) {
        this.tool = tool;
        this.schemaFilter = schemaFilter == null ? DefaultSchemaFilter.INSTANCE : schemaFilter;
    }

    public void setUniqueConstraintStrategy(UniqueConstraintSchemaUpdateStrategy uniqueConstraintStrategy) {
        this.uniqueConstraintStrategy = uniqueConstraintStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doMigration(Metadata metadata, ExecutionOptions options, TargetDescriptor targetDescriptor) {
        if (!targetDescriptor.getTargetTypes().isEmpty()) {
            JdbcContext jdbcContext = this.tool.resolveJdbcContext(options.getConfigurationValues());
            DdlTransactionIsolator ddlTransactionIsolator = this.tool.getDdlTransactionIsolator(jdbcContext);
            try {
                DatabaseInformation databaseInformation = Helper.buildDatabaseInformation(this.tool.getServiceRegistry(), ddlTransactionIsolator, metadata.getDatabase().getDefaultNamespace().getName());
                GenerationTarget[] targets = this.tool.buildGenerationTargets(targetDescriptor, ddlTransactionIsolator, options.getConfigurationValues());
                try {
                    for (GenerationTarget target : targets) {
                        target.prepare();
                    }
                    try {
                        this.performMigration(metadata, databaseInformation, options, jdbcContext.getDialect(), targets);
                    }
                    finally {
                        for (GenerationTarget target : targets) {
                            try {
                                target.release();
                            }
                            catch (Exception e) {
                                log.debugf("Problem releasing GenerationTarget [%s] : %s", (Object)target, (Object)e.getMessage());
                            }
                        }
                    }
                }
                finally {
                    try {
                        databaseInformation.cleanup();
                    }
                    catch (Exception e) {
                        log.debug("Problem releasing DatabaseInformation : " + e.getMessage());
                    }
                }
            }
            finally {
                ddlTransactionIsolator.release();
            }
        }
    }

    protected abstract NameSpaceTablesInformation performTablesMigration(Metadata var1, DatabaseInformation var2, ExecutionOptions var3, Dialect var4, Formatter var5, Set<String> var6, boolean var7, boolean var8, Set<Identifier> var9, Namespace var10, GenerationTarget[] var11);

    private void performMigration(Metadata metadata, DatabaseInformation existingDatabase, ExecutionOptions options, Dialect dialect, GenerationTarget ... targets) {
        NameSpaceTablesInformation nameSpaceTablesInformation;
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        Formatter formatter = format ? FormatStyle.DDL.getFormatter() : FormatStyle.NONE.getFormatter();
        HashSet<String> exportIdentifiers = new HashSet<String>(50);
        Database database = metadata.getDatabase();
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            AbstractSchemaMigrator.applySqlStrings(true, dialect.getAuxiliaryDatabaseObjectExporter().getSqlDropStrings(auxiliaryDatabaseObject, metadata), formatter, options, targets);
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            AbstractSchemaMigrator.applySqlStrings(true, auxiliaryDatabaseObject.sqlCreateStrings(dialect), formatter, options, targets);
        }
        boolean tryToCreateCatalogs = false;
        boolean tryToCreateSchemas = false;
        if (options.shouldManageNamespaces()) {
            if (dialect.canCreateSchema()) {
                tryToCreateSchemas = true;
            }
            if (dialect.canCreateCatalog()) {
                tryToCreateCatalogs = true;
            }
        }
        HashMap<Namespace, NameSpaceTablesInformation> tablesInformation = new HashMap<Namespace, NameSpaceTablesInformation>();
        HashSet<Identifier> exportedCatalogs = new HashSet<Identifier>();
        for (Namespace namespace : database.getNamespaces()) {
            nameSpaceTablesInformation = this.performTablesMigration(metadata, existingDatabase, options, dialect, formatter, exportIdentifiers, tryToCreateCatalogs, tryToCreateSchemas, exportedCatalogs, namespace, targets);
            tablesInformation.put(namespace, nameSpaceTablesInformation);
            if (!this.schemaFilter.includeNamespace(namespace)) continue;
            for (Sequence sequence : namespace.getSequences()) {
                this.checkExportIdentifier(sequence, exportIdentifiers);
                SequenceInformation sequenceInformation = existingDatabase.getSequenceInformation(sequence.getName());
                if (sequenceInformation != null) continue;
                AbstractSchemaMigrator.applySqlStrings(false, dialect.getSequenceExporter().getSqlCreateStrings(sequence, metadata), formatter, options, targets);
            }
        }
        for (Namespace namespace : database.getNamespaces()) {
            if (!this.schemaFilter.includeNamespace(namespace)) continue;
            nameSpaceTablesInformation = (NameSpaceTablesInformation)tablesInformation.get(namespace);
            for (Table table : namespace.getTables()) {
                TableInformation tableInformation;
                if (!this.schemaFilter.includeTable(table) || (tableInformation = nameSpaceTablesInformation.getTableInformation(table)) != null && (tableInformation == null || !tableInformation.isPhysicalTable())) continue;
                this.applyForeignKeys(table, tableInformation, dialect, metadata, formatter, options, targets);
            }
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            AbstractSchemaMigrator.applySqlStrings(true, auxiliaryDatabaseObject.sqlCreateStrings(dialect), formatter, options, targets);
        }
    }

    protected void createTable(Table table, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        AbstractSchemaMigrator.applySqlStrings(false, dialect.getTableExporter().getSqlCreateStrings(table, metadata), formatter, options, targets);
    }

    protected void migrateTable(Table table, TableInformation tableInformation, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        Database database = metadata.getDatabase();
        AbstractSchemaMigrator.applySqlStrings(false, table.sqlAlterStrings(dialect, metadata, tableInformation, this.getDefaultCatalogName(database, dialect), this.getDefaultSchemaName(database, dialect)), formatter, options, targets);
    }

    protected void applyIndexes(Table table, TableInformation tableInformation, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        Exporter<Index> exporter = dialect.getIndexExporter();
        Iterator<Index> indexItr = table.getIndexIterator();
        while (indexItr.hasNext()) {
            Index index = indexItr.next();
            if (StringHelper.isEmpty(index.getName())) continue;
            IndexInformation existingIndex = null;
            if (tableInformation != null) {
                existingIndex = this.findMatchingIndex(index, tableInformation);
            }
            if (existingIndex != null) continue;
            AbstractSchemaMigrator.applySqlStrings(false, exporter.getSqlCreateStrings(index, metadata), formatter, options, targets);
        }
    }

    private IndexInformation findMatchingIndex(Index index, TableInformation tableInformation) {
        return tableInformation.getIndex(Identifier.toIdentifier(index.getName()));
    }

    protected void applyUniqueKeys(Table table, TableInformation tableInfo, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (this.uniqueConstraintStrategy == null) {
            this.uniqueConstraintStrategy = this.determineUniqueConstraintSchemaUpdateStrategy(metadata);
        }
        if (this.uniqueConstraintStrategy != UniqueConstraintSchemaUpdateStrategy.SKIP) {
            Exporter<Constraint> exporter = dialect.getUniqueKeyExporter();
            Iterator<UniqueKey> ukItr = table.getUniqueKeyIterator();
            while (ukItr.hasNext()) {
                UniqueKey uniqueKey = ukItr.next();
                IndexInformation indexInfo = null;
                if (tableInfo != null && StringHelper.isNotEmpty(uniqueKey.getName())) {
                    indexInfo = tableInfo.getIndex(Identifier.toIdentifier(uniqueKey.getName()));
                }
                if (indexInfo != null) continue;
                if (this.uniqueConstraintStrategy == UniqueConstraintSchemaUpdateStrategy.DROP_RECREATE_QUIETLY) {
                    AbstractSchemaMigrator.applySqlStrings(true, exporter.getSqlDropStrings(uniqueKey, metadata), formatter, options, targets);
                }
                AbstractSchemaMigrator.applySqlStrings(true, exporter.getSqlCreateStrings(uniqueKey, metadata), formatter, options, targets);
            }
        }
    }

    private UniqueConstraintSchemaUpdateStrategy determineUniqueConstraintSchemaUpdateStrategy(Metadata metadata) {
        ConfigurationService cfgService = ((MetadataImplementor)metadata).getMetadataBuildingOptions().getServiceRegistry().getService(ConfigurationService.class);
        return UniqueConstraintSchemaUpdateStrategy.interpret(cfgService.getSetting("hibernate.schema_update.unique_constraint_strategy", StandardConverters.STRING));
    }

    protected void applyForeignKeys(Table table, TableInformation tableInformation, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (dialect.hasAlterTable()) {
            Exporter<ForeignKey> exporter = dialect.getForeignKeyExporter();
            Iterator fkItr = table.getForeignKeyIterator();
            while (fkItr.hasNext()) {
                ForeignKey foreignKey = (ForeignKey)fkItr.next();
                if (!foreignKey.isPhysicalConstraint() || !foreignKey.isCreationEnabled()) continue;
                boolean existingForeignKeyFound = false;
                if (tableInformation != null) {
                    existingForeignKeyFound = this.checkForExistingForeignKey(foreignKey, tableInformation);
                }
                if (existingForeignKeyFound) continue;
                AbstractSchemaMigrator.applySqlStrings(false, exporter.getSqlCreateStrings(foreignKey, metadata), formatter, options, targets);
            }
        }
    }

    private boolean checkForExistingForeignKey(ForeignKey foreignKey, TableInformation tableInformation) {
        if (foreignKey.getName() == null || tableInformation == null) {
            return false;
        }
        String referencingColumn = foreignKey.getColumn(0).getName();
        String referencedTable = foreignKey.getReferencedTable().getName();
        Predicate<ForeignKeyInformation.ColumnReferenceMapping> mappingPredicate = m -> {
            String existingReferencingColumn = m.getReferencingColumnMetadata().getColumnIdentifier().getText();
            String existingReferencedTable = m.getReferencedColumnMetadata().getContainingTableInformation().getName().getTableName().getCanonicalName();
            return referencingColumn.equals(existingReferencingColumn) && referencedTable.equals(existingReferencedTable);
        };
        Stream<ForeignKeyInformation> keyStream = StreamSupport.stream(tableInformation.getForeignKeys().spliterator(), false);
        Stream mappingStream = keyStream.flatMap(k -> StreamSupport.stream(k.getColumnReferenceMappings().spliterator(), false));
        boolean found = mappingStream.anyMatch(mappingPredicate);
        if (found) {
            return true;
        }
        return tableInformation.getForeignKey(Identifier.toIdentifier(foreignKey.getName())) != null;
    }

    protected void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException(String.format("Export identifier [%s] encountered more than once", exportIdentifier));
        }
        exportIdentifiers.add(exportIdentifier);
    }

    protected static void applySqlStrings(boolean quiet, String[] sqlStrings, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (sqlStrings != null) {
            for (String sqlString : sqlStrings) {
                AbstractSchemaMigrator.applySqlString(quiet, sqlString, formatter, options, targets);
            }
        }
    }

    protected void createSchemaAndCatalog(DatabaseInformation existingDatabase, ExecutionOptions options, Dialect dialect, Formatter formatter, boolean tryToCreateCatalogs, boolean tryToCreateSchemas, Set<Identifier> exportedCatalogs, Namespace namespace, GenerationTarget[] targets) {
        if (tryToCreateCatalogs || tryToCreateSchemas) {
            if (tryToCreateCatalogs) {
                Identifier catalogLogicalName = namespace.getName().getCatalog();
                Identifier catalogPhysicalName = namespace.getPhysicalName().getCatalog();
                if (catalogPhysicalName != null && !exportedCatalogs.contains(catalogLogicalName) && !existingDatabase.catalogExists(catalogLogicalName)) {
                    AbstractSchemaMigrator.applySqlStrings(false, dialect.getCreateCatalogCommand(catalogPhysicalName.render(dialect)), formatter, options, targets);
                    exportedCatalogs.add(catalogLogicalName);
                }
            }
            if (tryToCreateSchemas && namespace.getPhysicalName().getSchema() != null && !existingDatabase.schemaExists(namespace.getName())) {
                AbstractSchemaMigrator.applySqlStrings(false, dialect.getCreateSchemaCommand(namespace.getPhysicalName().getSchema().render(dialect)), formatter, options, targets);
            }
        }
    }

    private static void applySqlString(boolean quiet, String sqlString, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (!StringHelper.isEmpty(sqlString)) {
            String sqlStringFormatted = formatter.format(sqlString);
            for (GenerationTarget target : targets) {
                try {
                    target.accept(sqlStringFormatted);
                }
                catch (CommandAcceptanceException e) {
                    if (quiet) continue;
                    options.getExceptionHandler().handleException(e);
                }
            }
        }
    }

    private static void applySqlStrings(boolean quiet, Iterator<String> sqlStrings, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (sqlStrings != null) {
            while (sqlStrings.hasNext()) {
                String sqlString = sqlStrings.next();
                AbstractSchemaMigrator.applySqlString(quiet, sqlString, formatter, options, targets);
            }
        }
    }

    private String getDefaultCatalogName(Database database, Dialect dialect) {
        Identifier identifier = database.getDefaultNamespace().getPhysicalName().getCatalog();
        return identifier == null ? null : identifier.render(dialect);
    }

    private String getDefaultSchemaName(Database database, Dialect dialect) {
        Identifier identifier = database.getDefaultNamespace().getPhysicalName().getSchema();
        return identifier == null ? null : identifier.render(dialect);
    }
}

