/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import java.util.Vector;
import org.evosuite.shaded.org.hsqldb.Database;
import org.evosuite.shaded.org.hsqldb.DatabaseType;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.FileUtil;
import org.evosuite.shaded.org.hsqldb.lib.HashMap;
import org.evosuite.shaded.org.hsqldb.lib.HashSet;
import org.evosuite.shaded.org.hsqldb.lib.HsqlTimer;
import org.evosuite.shaded.org.hsqldb.lib.IntKeyHashMap;
import org.evosuite.shaded.org.hsqldb.lib.Iterator;
import org.evosuite.shaded.org.hsqldb.lib.Notified;
import org.evosuite.shaded.org.hsqldb.map.BaseHashMap;
import org.evosuite.shaded.org.hsqldb.map.ValuePool;
import org.evosuite.shaded.org.hsqldb.persist.HsqlProperties;

public class DatabaseManager {
    private static int dbIDCounter;
    static final HashMap memDatabaseMap;
    static final HashMap fileDatabaseMap;
    static final HashMap resDatabaseMap;
    static final IntKeyHashMap databaseIDMap;
    static final HashMap serverMap;
    private static final HsqlTimer timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getDatabaseURIs() {
        Vector<String> vector = new Vector<String>();
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            Iterator iterator = databaseIDMap.values().iterator();
            while (iterator.hasNext()) {
                Database database = (Database)iterator.next();
                vector.addElement(database.getURI());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDatabases(int n) {
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            Iterator iterator = databaseIDMap.values().iterator();
            while (iterator.hasNext()) {
                Database database = (Database)iterator.next();
                try {
                    database.close(n);
                }
                catch (HsqlException hsqlException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session newSession(int n, String string, String string2, String string3, int n2) {
        Database database = null;
        Object object = databaseIDMap;
        synchronized (object) {
            database = (Database)databaseIDMap.get(n);
        }
        if (database == null) {
            return null;
        }
        object = database.connect(string, string2, string3, n2);
        ((Session)object).isNetwork = true;
        return object;
    }

    public static Session newSession(String string, String string2, String string3, String string4, HsqlProperties hsqlProperties, String string5, int n) {
        Database database = DatabaseManager.getDatabase(string, string2, hsqlProperties);
        return database.connect(string3, string4, string5, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(int n, long l) {
        Database database = null;
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            database = (Database)databaseIDMap.get(n);
        }
        return database == null ? null : database.sessionManager.getSession(l);
    }

    public static int getDatabase(String string, String string2, Notified notified, HsqlProperties hsqlProperties) {
        Database database = DatabaseManager.getDatabase(string, string2, hsqlProperties);
        DatabaseManager.registerServer(notified, database);
        return database.databaseID;
    }

    public static Database getDatabase(int n) {
        return (Database)databaseIDMap.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownDatabases(Notified notified, int n) {
        Object[] objectArray;
        HashMap hashMap = serverMap;
        synchronized (hashMap) {
            HashSet hashSet = (HashSet)serverMap.get(notified);
            if (hashSet == null) {
                objectArray = new Database[]{};
            } else {
                objectArray = new Database[hashSet.size()];
                hashSet.toArray(objectArray);
            }
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((Database)objectArray[i]).close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(String string, String string2, HsqlProperties hsqlProperties) {
        Database database;
        DatabaseType databaseType = DatabaseType.get(string);
        Database database2 = database = DatabaseManager.getDatabaseObject(databaseType, string2, hsqlProperties);
        synchronized (database2) {
            switch (database.getState()) {
                case 1: {
                    break;
                }
                case 4: {
                    if (DatabaseManager.lookupDatabaseObject(databaseType, string2) == null) {
                        DatabaseManager.addDatabaseObject(databaseType, string2, database);
                    }
                    database.open();
                    break;
                }
                case 2: 
                case 3: {
                    throw Error.error(451, 23);
                }
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Database getDatabaseObject(DatabaseType databaseType, String string, HsqlProperties hsqlProperties) {
        Object object;
        Database database;
        HashMap hashMap;
        String string2 = string;
        block2 : switch (databaseType) {
            case DB_FILE: {
                hashMap = fileDatabaseMap;
                string2 = DatabaseManager.filePathToKey(string);
                database = (Database)hashMap.get(string2);
                if (database != null || hashMap.size() <= 0) break;
                object = hashMap.keySet().iterator();
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    if (!string2.equalsIgnoreCase(string3)) continue;
                    string2 = string3;
                    break block2;
                }
                break;
            }
            case DB_RES: {
                hashMap = resDatabaseMap;
                break;
            }
            case DB_MEM: {
                hashMap = memDatabaseMap;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DatabaseManager");
            }
        }
        if ((database = (Database)hashMap.get(string2)) == null) {
            database = new Database(databaseType, string, string2, hsqlProperties);
            database.databaseID = dbIDCounter;
            object = databaseIDMap;
            synchronized (object) {
                databaseIDMap.put(dbIDCounter, database);
                ++dbIDCounter;
            }
            hashMap.put(string2, database);
        }
        return database;
    }

    public static synchronized Database lookupDatabaseObject(DatabaseType databaseType, String string) {
        HashMap hashMap;
        String string2 = string;
        if (databaseType == DatabaseType.DB_FILE) {
            hashMap = fileDatabaseMap;
            string2 = DatabaseManager.filePathToKey(string);
        } else if (databaseType == DatabaseType.DB_RES) {
            hashMap = resDatabaseMap;
        } else if (databaseType == DatabaseType.DB_MEM) {
            hashMap = memDatabaseMap;
        } else {
            throw Error.runtimeError(201, "DatabaseManager");
        }
        return (Database)hashMap.get(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void addDatabaseObject(DatabaseType databaseType, String string, Database database) {
        HashMap hashMap;
        String string2 = string;
        if (databaseType == DatabaseType.DB_FILE) {
            hashMap = fileDatabaseMap;
            string2 = DatabaseManager.filePathToKey(string);
        } else if (databaseType == DatabaseType.DB_RES) {
            hashMap = resDatabaseMap;
        } else if (databaseType == DatabaseType.DB_MEM) {
            hashMap = memDatabaseMap;
        } else {
            throw Error.runtimeError(201, "DatabaseManager");
        }
        IntKeyHashMap intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            databaseIDMap.put(database.databaseID, database);
        }
        hashMap.put(string2, database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeDatabase(Database database) {
        HashMap hashMap;
        String string;
        int n = database.databaseID;
        DatabaseType databaseType = database.getType();
        String string2 = string = database.getPath();
        DatabaseManager.notifyServers(database);
        if (databaseType == DatabaseType.DB_FILE) {
            hashMap = fileDatabaseMap;
            string2 = DatabaseManager.filePathToKey(string);
        } else if (databaseType == DatabaseType.DB_RES) {
            hashMap = resDatabaseMap;
        } else if (databaseType == DatabaseType.DB_MEM) {
            hashMap = memDatabaseMap;
        } else {
            throw Error.runtimeError(201, "DatabaseManager");
        }
        boolean bl = false;
        BaseHashMap baseHashMap = databaseIDMap;
        synchronized (baseHashMap) {
            databaseIDMap.remove(n);
            bl = databaseIDMap.isEmpty();
        }
        baseHashMap = hashMap;
        synchronized (baseHashMap) {
            hashMap.remove(string2);
        }
        if (bl) {
            ValuePool.resetPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deRegisterServer(Notified notified) {
        HashMap hashMap = serverMap;
        synchronized (hashMap) {
            serverMap.remove(notified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerServer(Notified notified, Database database) {
        HashMap hashMap = serverMap;
        synchronized (hashMap) {
            if (!serverMap.containsKey(notified)) {
                serverMap.put(notified, new HashSet());
            }
            HashSet hashSet = (HashSet)serverMap.get(notified);
            hashSet.add(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServers(Database database) {
        Object[] objectArray;
        HashMap hashMap = serverMap;
        synchronized (hashMap) {
            objectArray = new Notified[serverMap.size()];
            serverMap.keysToArray(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            HashSet hashSet;
            Object object = objectArray[i];
            boolean bl = false;
            BaseHashMap baseHashMap = serverMap;
            synchronized (baseHashMap) {
                hashSet = (HashSet)serverMap.get(object);
            }
            if (hashSet != null) {
                baseHashMap = hashSet;
                synchronized (baseHashMap) {
                    bl = hashSet.remove(database);
                }
            }
            if (!bl) continue;
            object.notify(database.databaseID);
        }
    }

    static boolean isServerDB(Database database) {
        Iterator iterator = serverMap.keySet().iterator();
        while (iterator.hasNext()) {
            Notified notified = (Notified)iterator.next();
            HashSet hashSet = (HashSet)serverMap.get(notified);
            if (!hashSet.contains(database)) continue;
            return true;
        }
        return false;
    }

    public static HsqlTimer getTimer() {
        return timer;
    }

    private static String filePathToKey(String string) {
        try {
            return FileUtil.getFileUtil().canonicalPath(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    static {
        memDatabaseMap = new HashMap();
        fileDatabaseMap = new HashMap();
        resDatabaseMap = new HashMap();
        databaseIDMap = new IntKeyHashMap();
        serverMap = new HashMap();
        timer = new HsqlTimer();
    }
}

