/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb;

import org.evosuite.shaded.org.hsqldb.ExpressionColumn;
import org.evosuite.shaded.org.hsqldb.HsqlNameManager;
import org.evosuite.shaded.org.hsqldb.ParserDQL;
import org.evosuite.shaded.org.hsqldb.Routine;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.StatementCompound;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.OrderedHashSet;
import org.evosuite.shaded.org.hsqldb.result.Result;
import org.evosuite.shaded.org.hsqldb.result.ResultMetaData;

public abstract class Statement {
    static final int META_RESET_VIEWS = 1;
    static final int META_RESET_STATEMENTS = 2;
    static final Statement[] emptyArray = new Statement[0];
    final int type;
    int group;
    boolean isLogged = true;
    boolean isValid = true;
    int statementReturnType = 1;
    HsqlNameManager.HsqlName schemaName;
    Routine root;
    StatementCompound parent;
    boolean isError;
    boolean isTransactionStatement;
    boolean isExplain;
    String sql;
    long id;
    long compileTimestamp;
    HsqlNameManager.HsqlName[] readTableNames = HsqlNameManager.HsqlName.emptyArray;
    HsqlNameManager.HsqlName[] writeTableNames = HsqlNameManager.HsqlName.emptyArray;
    OrderedHashSet references;
    int cursorPropertiesRequest;
    ExpressionColumn[] parameters;
    ResultMetaData parameterMetaData = ResultMetaData.emptyParamMetaData;
    static final String PCOL_PREFIX = "@p";
    static final String RETURN_COLUMN_NAME = "@p0";

    public abstract Result execute(Session var1);

    public void setParameters(ExpressionColumn[] expressionColumnArray) {
    }

    Statement(int n) {
        this.type = n;
    }

    Statement(int n, int n2) {
        this.type = n;
        this.group = n2;
    }

    public final boolean isError() {
        return this.isError;
    }

    public boolean isTransactionStatement() {
        return this.isTransactionStatement;
    }

    public boolean isAutoCommitStatement() {
        return false;
    }

    public void setCompileTimestamp(long l) {
        this.compileTimestamp = l;
    }

    public long getCompileTimestamp() {
        return this.compileTimestamp;
    }

    public final void setSQL(String string) {
        this.sql = string;
    }

    public String getSQL() {
        return this.sql;
    }

    public OrderedHashSet getReferences() {
        return this.references;
    }

    public final void setDescribe() {
        this.isExplain = true;
    }

    public abstract String describe(Session var1);

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.schemaName;
    }

    public final void setSchemaHsqlName(HsqlNameManager.HsqlName hsqlName) {
        this.schemaName = hsqlName;
    }

    public final void setID(long l) {
        this.id = l;
    }

    public final long getID() {
        return this.id;
    }

    public final int getType() {
        return this.type;
    }

    public final int getGroup() {
        return this.group;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final boolean isLogged() {
        return this.isLogged;
    }

    public void clearVariables() {
    }

    public void resolve(Session session) {
    }

    public final HsqlNameManager.HsqlName[] getTableNamesForRead() {
        return this.readTableNames;
    }

    public final HsqlNameManager.HsqlName[] getTableNamesForWrite() {
        return this.writeTableNames;
    }

    public boolean isCatalogLock(int n) {
        switch (this.group) {
            case 2002: {
                if (this.type == 5) {
                    return false;
                }
                if (this.writeTableNames.length == 0) {
                    return false;
                }
            }
            case 2001: {
                return n == 2;
            }
            case 2012: 
            case 2014: {
                return true;
            }
        }
        return false;
    }

    public boolean isCatalogChange() {
        switch (this.group) {
            case 2001: 
            case 2002: 
            case 2012: {
                return true;
            }
        }
        return false;
    }

    public void setParent(StatementCompound statementCompound) {
        this.parent = statementCompound;
    }

    public void setRoot(Routine routine) {
        this.root = routine;
    }

    public boolean hasGeneratedColumns() {
        return false;
    }

    public ResultMetaData generatedResultMetaData() {
        return null;
    }

    public void setGeneratedColumnInfo(int n, ResultMetaData resultMetaData) {
    }

    public ResultMetaData getResultMetaData() {
        return ResultMetaData.emptyResultMetaData;
    }

    public ResultMetaData getParametersMetaData() {
        return this.parameterMetaData;
    }

    public int getResultProperties() {
        return 0;
    }

    public int getStatementReturnType() {
        return this.statementReturnType;
    }

    public int getCursorPropertiesRequest() {
        return this.cursorPropertiesRequest;
    }

    public void setCursorPropertiesRequest(int n) {
        this.cursorPropertiesRequest = n;
    }

    public void clearStructures(Session session) {
    }

    void setDatabaseObjects(Session session, ParserDQL.CompileContext compileContext) {
        this.parameters = compileContext.getParameters();
        this.setParameterMetaData();
    }

    void setParameterMetaData() {
        int n = 0;
        if (this.parameters.length == 0) {
            this.parameterMetaData = ResultMetaData.emptyParamMetaData;
            return;
        }
        this.parameterMetaData = ResultMetaData.newParameterMetaData(this.parameters.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            int n2 = i + n;
            this.parameterMetaData.columnLabels[n2] = PCOL_PREFIX + (i + 1);
            this.parameterMetaData.columnTypes[n2] = this.parameters[i].dataType;
            if (this.parameters[i].dataType == null) {
                throw Error.error(5567);
            }
            byte by = 1;
            if (this.parameters[i].column != null && this.parameters[i].column.getParameterMode() != 0) {
                by = this.parameters[i].column.getParameterMode();
            }
            this.parameterMetaData.paramModes[n2] = by;
            this.parameterMetaData.paramNullable[n2] = this.parameters[i].column == null ? (byte)1 : this.parameters[i].column.getNullability();
        }
    }
}

