/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.lib;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class CharArrayWriter {
    protected char[] buffer;
    protected int count;

    public CharArrayWriter(int n) {
        this.buffer = new char[n];
    }

    public CharArrayWriter(char[] cArray) {
        this.buffer = cArray;
    }

    public CharArrayWriter(Reader reader, int n) throws IOException {
        this.buffer = new char[n];
        int n2 = n;
        while (n2 > 0) {
            int n3 = reader.read(this.buffer, this.count, n2);
            if (n3 == -1) {
                if (n2 <= 0) break;
                reader.close();
                throw new EOFException();
            }
            n2 -= n3;
            this.count += n3;
        }
    }

    public CharArrayWriter(Reader reader) throws IOException {
        int n;
        this.buffer = new char[128];
        while ((n = reader.read(this.buffer, this.count, this.buffer.length - this.count)) != -1) {
            this.count += n;
            if (this.count != this.buffer.length) continue;
            this.ensureRoom(this.count * 2);
        }
    }

    public void write(int n) {
        if (this.count == this.buffer.length) {
            this.ensureRoom(this.count + 1);
        }
        this.buffer[this.count++] = (char)n;
    }

    public int write(Reader reader, int n) throws IOException {
        int n2;
        int n3 = n;
        while (n3 > 0 && (n2 = reader.read(this.buffer, this.count, n3)) != -1) {
            n3 -= n2;
            this.count += n2;
        }
        return n - n3;
    }

    void ensureRoom(int n) {
        int n2;
        if (n <= this.buffer.length) {
            return;
        }
        for (n2 = this.buffer.length; n2 < n; n2 *= 2) {
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.buffer, 0, cArray, 0, this.count);
        this.buffer = cArray;
    }

    public void write(String string, int n, int n2) {
        this.ensureRoom(this.count + n2);
        string.getChars(n, n + n2, this.buffer, this.count);
        this.count += n2;
    }

    public void reset() {
        this.count = 0;
    }

    public void reset(char[] cArray) {
        this.count = 0;
        this.buffer = cArray;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        System.arraycopy(this.buffer, 0, cArray, 0, this.count);
        return cArray;
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public int size() {
        return this.count;
    }

    public void setSize(int n) {
        if (n > this.buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.count = n;
    }

    public String toString() {
        return new String(this.buffer, 0, this.count);
    }
}

