/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.evosuite.shaded.org.hsqldb.lib.BaseList;
import org.evosuite.shaded.org.hsqldb.lib.HsqlList;

public class HsqlDeque
extends BaseList
implements HsqlList {
    private Object[] list = new Object[10];
    private int firstindex = 0;
    private int endindex = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.firstindex];
    }

    public Object getLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.endindex - 1];
    }

    @Override
    public Object get(int n) throws IndexOutOfBoundsException {
        int n2 = this.getInternalIndex(n);
        return this.list[n2];
    }

    @Override
    public void add(int n, Object object) throws IndexOutOfBoundsException {
        if (n == this.elementCount) {
            this.add(object);
            return;
        }
        this.resetCapacity();
        int n2 = this.getInternalIndex(n);
        if (n2 < this.endindex && this.endindex < this.list.length) {
            System.arraycopy(this.list, n2, this.list, n2 + 1, this.endindex - n2);
            ++this.endindex;
        } else {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex - 1, n2 - this.firstindex);
            --this.firstindex;
            --n2;
        }
        this.list[n2] = object;
        ++this.elementCount;
    }

    @Override
    public Object set(int n, Object object) throws IndexOutOfBoundsException {
        int n2 = this.getInternalIndex(n);
        Object object2 = this.list[n2];
        this.list[n2] = object;
        return object2;
    }

    public Object removeFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        Object object = this.list[this.firstindex];
        this.list[this.firstindex] = null;
        ++this.firstindex;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.length) {
            this.firstindex = 0;
        }
        return object;
    }

    public Object removeLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        Object object = this.list[this.endindex];
        this.list[this.endindex] = null;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.length;
        }
        return object;
    }

    @Override
    public boolean add(Object object) {
        this.resetCapacity();
        if (this.endindex == this.list.length) {
            this.endindex = 0;
        }
        this.list[this.endindex] = object;
        ++this.elementCount;
        ++this.endindex;
        return true;
    }

    public boolean addLast(Object object) {
        return this.add(object);
    }

    public boolean addFirst(Object object) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.length - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        this.list[this.firstindex] = object;
        ++this.elementCount;
        return true;
    }

    @Override
    public void clear() {
        if (this.elementCount == 0) {
            return;
        }
        this.elementCount = 0;
        this.endindex = 0;
        this.firstindex = 0;
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i] = null;
        }
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.elementCount; ++i) {
            int n = this.firstindex + i;
            if (n >= this.list.length) {
                n -= this.list.length;
            }
            if (this.list[n] == object) {
                return i;
            }
            if (object == null || !object.equals(this.list[n])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object remove(int n) {
        int n2 = this.getInternalIndex(n);
        Object object = this.list[n2];
        if (n2 == this.firstindex) {
            this.list[this.firstindex] = null;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else if (n2 > this.firstindex) {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex + 1, n2 - this.firstindex);
            this.list[this.firstindex] = null;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else {
            System.arraycopy(this.list, n2 + 1, this.list, n2, this.endindex - n2 - 1);
            --this.endindex;
            this.list[this.endindex] = null;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        }
        return object;
    }

    private int getInternalIndex(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.firstindex + n;
        if (n2 >= this.list.length) {
            n2 -= this.list.length;
        }
        return n2;
    }

    private void resetCapacity() {
        if (this.elementCount < this.list.length) {
            return;
        }
        Object[] objectArray = new Object[this.list.length * 2];
        System.arraycopy(this.list, this.firstindex, objectArray, this.firstindex, this.list.length - this.firstindex);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, objectArray, this.list.length, this.endindex);
            this.endindex = this.list.length + this.endindex;
        }
        this.list = objectArray;
    }

    public void toArray(Object[] objectArray) {
        int n = this.list.length - this.firstindex;
        if (n > this.elementCount) {
            n = this.elementCount;
        }
        System.arraycopy(this.list, this.firstindex, objectArray, 0, n);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, objectArray, n, this.endindex);
            this.endindex = this.list.length + this.endindex;
        }
    }
}

