/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.lib;

import org.evosuite.shaded.org.hsqldb.lib.HsqlDeque;

public class HsqlTaskQueue {
    protected Thread taskRunnerThread;
    protected static final Runnable SHUTDOWNTASK = new Runnable(){

        @Override
        public void run() {
        }
    };
    protected volatile boolean isShutdown;
    protected final HsqlDeque queue = new HsqlDeque();
    protected final TaskRunner taskRunner = new TaskRunner();

    public synchronized Thread getTaskRunnerThread() {
        return this.taskRunnerThread;
    }

    protected synchronized void clearThread() {
        try {
            this.taskRunnerThread.setContextClassLoader(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.taskRunnerThread = null;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public synchronized void restart() {
        if (this.taskRunnerThread == null && !this.isShutdown) {
            this.taskRunnerThread = new Thread(this.taskRunner);
            this.taskRunnerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable) throws RuntimeException {
        if (!this.isShutdown) {
            HsqlDeque hsqlDeque = this.queue;
            synchronized (hsqlDeque) {
                this.queue.addLast(runnable);
            }
            this.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownAfterQueued() {
        if (!this.isShutdown) {
            HsqlDeque hsqlDeque = this.queue;
            synchronized (hsqlDeque) {
                this.queue.addLast(SHUTDOWNTASK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownAfterCurrent() {
        this.isShutdown = true;
        HsqlDeque hsqlDeque = this.queue;
        synchronized (hsqlDeque) {
            this.queue.clear();
            this.queue.addLast(SHUTDOWNTASK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownImmediately() {
        this.isShutdown = true;
        if (this.taskRunnerThread != null) {
            this.taskRunnerThread.interrupt();
        }
        HsqlDeque hsqlDeque = this.queue;
        synchronized (hsqlDeque) {
            this.queue.clear();
            this.queue.addLast(SHUTDOWNTASK);
        }
    }

    protected class TaskRunner
    implements Runnable {
        protected TaskRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!HsqlTaskQueue.this.isShutdown) {
                    Runnable runnable;
                    HsqlDeque hsqlDeque = HsqlTaskQueue.this.queue;
                    synchronized (hsqlDeque) {
                        runnable = (Runnable)HsqlTaskQueue.this.queue.getFirst();
                    }
                    if (runnable == SHUTDOWNTASK) {
                        HsqlTaskQueue.this.isShutdown = true;
                        hsqlDeque = HsqlTaskQueue.this.queue;
                        synchronized (hsqlDeque) {
                            HsqlTaskQueue.this.queue.clear();
                            break;
                        }
                    }
                    if (runnable != null) {
                        runnable.run();
                        runnable = null;
                        continue;
                    }
                    break;
                }
            }
            finally {
                HsqlTaskQueue.this.clearThread();
            }
        }
    }
}

