/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class KMPSearchAlgorithm {
    public static long search(InputStream inputStream, byte[] byArray, int[] nArray) throws IOException {
        int n;
        if (inputStream == null || byArray == null || byArray.length == 0) {
            return -1L;
        }
        int n2 = byArray.length;
        long l = -1L;
        if (n2 == 1) {
            int n3;
            byte by = byArray[0];
            while (-1 != (n3 = inputStream.read())) {
                ++l;
                if (n3 != by) continue;
                return l;
            }
            return -1L;
        }
        int n4 = 0;
        if (nArray == null) {
            nArray = KMPSearchAlgorithm.computeTable(byArray);
        }
        while (-1 != (n = inputStream.read())) {
            ++l;
            if (n == byArray[n4]) {
                ++n4;
            } else if (n4 > 0) {
                n4 = nArray[n4];
                ++n4;
            }
            if (n4 != n2) continue;
            return l - (long)(n2 - 1);
        }
        return -1L;
    }

    public static long search(Reader reader, char[] cArray, int[] nArray) throws IOException {
        int n;
        if (reader == null || cArray == null || cArray.length == 0) {
            return -1L;
        }
        int n2 = cArray.length;
        long l = -1L;
        if (n2 == 1) {
            int n3;
            char c = cArray[0];
            while (-1 != (n3 = reader.read())) {
                ++l;
                if (n3 != c) continue;
                return l;
            }
            return -1L;
        }
        int n4 = 0;
        if (nArray == null) {
            nArray = KMPSearchAlgorithm.computeTable(cArray);
        }
        while (-1 != (n = reader.read())) {
            ++l;
            if (n == cArray[n4]) {
                ++n4;
            } else if (n4 > 0) {
                n4 = nArray[n4];
                ++n4;
            }
            if (n4 != n2) continue;
            return l - (long)(n2 - 1);
        }
        return -1L;
    }

    public static int search(byte[] byArray, byte[] byArray2, int[] nArray, int n) {
        int n2;
        if (byArray == null || byArray2 == null || byArray2.length == 0) {
            return -1;
        }
        int n3 = byArray.length;
        int n4 = byArray2.length;
        if (n4 == 1) {
            byte by = byArray2[0];
            for (n2 = n; n2 < n3; ++n2) {
                if (byArray[n2] != by) continue;
                return n2;
            }
            return -1;
        }
        int n5 = n;
        int n6 = 0;
        if (nArray == null) {
            nArray = KMPSearchAlgorithm.computeTable(byArray2);
        }
        while (n2 < n3 && n6 < n4) {
            if (byArray[n2] == byArray2[n6]) {
                ++n6;
            } else {
                int n7 = nArray[n6];
                n5 += n6 - n7;
                if (n6 > 0) {
                    n6 = n7;
                }
                ++n6;
            }
            n2 = n5 + n6;
        }
        if (n6 == n4) {
            return n5;
        }
        return -1;
    }

    public static int search(char[] cArray, char[] cArray2, int[] nArray, int n) {
        int n2;
        if (cArray == null || cArray2 == null || cArray2.length == 0) {
            return -1;
        }
        int n3 = cArray.length;
        int n4 = cArray2.length;
        if (n4 == 1) {
            char c = cArray2[0];
            for (n2 = n; n2 < n3; ++n2) {
                if (cArray[n2] != c) continue;
                return n2;
            }
            return -1;
        }
        int n5 = n;
        int n6 = 0;
        if (nArray == null) {
            nArray = KMPSearchAlgorithm.computeTable(cArray2);
        }
        while (n2 < n3 && n6 < n4) {
            if (cArray[n2] == cArray2[n6]) {
                ++n6;
            } else {
                int n7 = nArray[n6];
                n5 += n6 - n7;
                if (n6 > 0) {
                    n6 = n7;
                }
                ++n6;
            }
            n2 = n5 + n6;
        }
        if (n6 == n4) {
            return n5;
        }
        return -1;
    }

    public static int search(String string, String string2, int[] nArray, int n) {
        if (string == null || string2 == null || string2.length() == 0) {
            return -1;
        }
        int n2 = string2.length();
        if (n2 == 1) {
            return string.indexOf(string2, n);
        }
        int n3 = string.length();
        int n4 = n;
        int n5 = n;
        int n6 = 0;
        if (nArray == null) {
            nArray = KMPSearchAlgorithm.computeTable(string2);
        }
        while (n5 < n3 && n6 < n2) {
            if (string.charAt(n5) == string2.charAt(n6)) {
                ++n6;
            } else {
                int n7 = nArray[n6];
                n4 += n6 - n7;
                if (n6 > 0) {
                    n6 = n7;
                }
                ++n6;
            }
            n5 = n4 + n6;
        }
        if (n6 == n2) {
            return n4;
        }
        return -1;
    }

    public static int[] computeTable(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Pattern must  not be null.");
        }
        if (byArray.length < 2) {
            throw new IllegalArgumentException("Pattern length must be > 1.");
        }
        int[] nArray = new int[byArray.length];
        int n = 2;
        int n2 = 0;
        nArray[0] = -1;
        nArray[1] = 0;
        while (n < byArray.length) {
            if (byArray[n - 1] == byArray[n2]) {
                nArray[n] = n2 + 1;
                ++n2;
                ++n;
                continue;
            }
            if (n2 > 0) {
                n2 = nArray[n2];
                continue;
            }
            nArray[n] = 0;
            ++n;
            n2 = 0;
        }
        return nArray;
    }

    public static int[] computeTable(char[] cArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("Pattern must  not be null.");
        }
        if (cArray.length < 2) {
            throw new IllegalArgumentException("Pattern length must be > 1.");
        }
        int[] nArray = new int[cArray.length];
        int n = 2;
        int n2 = 0;
        nArray[0] = -1;
        nArray[1] = 0;
        while (n < cArray.length) {
            if (cArray[n - 1] == cArray[n2]) {
                nArray[n] = n2 + 1;
                ++n2;
                ++n;
                continue;
            }
            if (n2 > 0) {
                n2 = nArray[n2];
                continue;
            }
            nArray[n] = 0;
            ++n;
            n2 = 0;
        }
        return nArray;
    }

    public static int[] computeTable(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Pattern must  not be null.");
        }
        if (string.length() < 2) {
            throw new IllegalArgumentException("Pattern length must be > 1.");
        }
        int n = string.length();
        int[] nArray = new int[n];
        int n2 = 2;
        int n3 = 0;
        nArray[0] = -1;
        nArray[1] = 0;
        while (n2 < n) {
            if (string.charAt(n2 - 1) == string.charAt(n3)) {
                nArray[n2] = n3 + 1;
                ++n3;
                ++n2;
                continue;
            }
            if (n3 > 0) {
                n3 = nArray[n3];
                continue;
            }
            nArray[n2] = 0;
            ++n2;
            n3 = 0;
        }
        return nArray;
    }
}

