/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.persist;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.StringConverter;

public class Crypto {
    SecretKeySpec key;
    Cipher outCipher;
    Cipher inCipher;
    Cipher inStreamCipher;
    Cipher outStreamCipher;

    public Crypto(String string, String string2, String string3) {
        try {
            byte[] byArray = StringConverter.hexStringToByteArray(string);
            this.key = new SecretKeySpec(byArray, string2);
            this.outCipher = string3 == null ? Cipher.getInstance(string2) : Cipher.getInstance(string2, string3);
            this.outCipher.init(1, this.key);
            this.outStreamCipher = string3 == null ? Cipher.getInstance(string2) : Cipher.getInstance(string2, string3);
            this.outStreamCipher.init(1, this.key);
            this.inCipher = string3 == null ? Cipher.getInstance(string2) : Cipher.getInstance(string2, string3);
            this.inCipher.init(2, this.key);
            this.inStreamCipher = string3 == null ? Cipher.getInstance(string2) : Cipher.getInstance(string2, string3);
            this.inStreamCipher.init(2, this.key);
            return;
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw Error.error(331, noSuchPaddingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Error.error(331, noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw Error.error(331, invalidKeyException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw Error.error(331, noSuchProviderException);
        }
        catch (IOException iOException) {
            throw Error.error(331, iOException);
        }
    }

    public synchronized InputStream getInputStream(InputStream inputStream) {
        if (this.inCipher == null) {
            return inputStream;
        }
        try {
            this.inStreamCipher.init(2, this.key);
            return new CipherInputStream(inputStream, this.inStreamCipher);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw Error.error(331, invalidKeyException);
        }
    }

    public synchronized OutputStream getOutputStream(OutputStream outputStream) {
        if (this.outCipher == null) {
            return outputStream;
        }
        try {
            this.outStreamCipher.init(1, this.key);
            return new CipherOutputStream(outputStream, this.outStreamCipher);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw Error.error(331, invalidKeyException);
        }
    }

    public synchronized int decode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.inCipher == null) {
            return n2;
        }
        try {
            this.inCipher.init(2, this.key);
            return this.inCipher.doFinal(byArray, n, n2, byArray2, n3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw Error.error(331, invalidKeyException);
        }
        catch (BadPaddingException badPaddingException) {
            throw Error.error(331, badPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw Error.error(331, illegalBlockSizeException);
        }
        catch (ShortBufferException shortBufferException) {
            throw Error.error(331, shortBufferException);
        }
    }

    public synchronized int encode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.outCipher == null) {
            return n2;
        }
        try {
            this.outCipher.init(1, this.key);
            return this.outCipher.doFinal(byArray, n, n2, byArray2, n3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw Error.error(331, invalidKeyException);
        }
        catch (BadPaddingException badPaddingException) {
            throw Error.error(331, badPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw Error.error(331, illegalBlockSizeException);
        }
        catch (ShortBufferException shortBufferException) {
            throw Error.error(331, shortBufferException);
        }
    }

    public static byte[] getNewKey(String string, String string2) {
        try {
            KeyGenerator keyGenerator = string2 == null ? KeyGenerator.getInstance(string) : KeyGenerator.getInstance(string, string2);
            SecretKey secretKey = keyGenerator.generateKey();
            byte[] byArray = secretKey.getEncoded();
            return byArray;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Error.error(331, noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw Error.error(331, noSuchProviderException);
        }
    }

    public synchronized int getEncodedSize(int n) {
        try {
            return this.outCipher.getOutputSize(n);
        }
        catch (IllegalStateException illegalStateException) {
            try {
                this.outCipher.init(1, this.key);
                return this.outCipher.getOutputSize(n);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw Error.error(331, invalidKeyException);
            }
        }
    }
}

