/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.rowio;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import org.evosuite.shaded.org.hsqldb.Row;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.StringConverter;
import org.evosuite.shaded.org.hsqldb.rowio.RowOutputBase;
import org.evosuite.shaded.org.hsqldb.rowio.RowOutputInterface;
import org.evosuite.shaded.org.hsqldb.types.BinaryData;
import org.evosuite.shaded.org.hsqldb.types.BlobData;
import org.evosuite.shaded.org.hsqldb.types.ClobData;
import org.evosuite.shaded.org.hsqldb.types.IntervalMonthData;
import org.evosuite.shaded.org.hsqldb.types.IntervalSecondData;
import org.evosuite.shaded.org.hsqldb.types.JavaObjectData;
import org.evosuite.shaded.org.hsqldb.types.TimeData;
import org.evosuite.shaded.org.hsqldb.types.TimestampData;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class RowOutputTextLog
extends RowOutputBase {
    static byte[] BYTES_NULL;
    static byte[] BYTES_TRUE;
    static byte[] BYTES_FALSE;
    static byte[] BYTES_AND;
    static byte[] BYTES_IS;
    static byte[] BYTES_ARRAY;
    public static final int MODE_DELETE = 1;
    public static final int MODE_INSERT = 0;
    private boolean isWritten;
    private int logMode;
    private boolean noSeparators;

    public void setMode(int n) {
        this.logMode = n;
    }

    @Override
    protected void writeFieldPrefix() {
        if (!this.noSeparators && this.logMode == 1 && this.isWritten) {
            this.write(BYTES_AND);
        }
    }

    @Override
    protected void writeChar(String string, Type type) {
        this.write(39);
        StringConverter.stringToUnicodeBytes(this, string, true);
        this.write(39);
    }

    @Override
    protected void writeReal(Double d) {
        this.writeBytes(Type.SQL_DOUBLE.convertToSQLString(d));
    }

    @Override
    protected void writeSmallint(Number number) {
        this.writeBytes(number.toString());
    }

    @Override
    public long scalePosition(long l) {
        return l;
    }

    @Override
    public void setStorageSize(int n) {
    }

    @Override
    public void writeEnd() {
    }

    @Override
    protected void writeBit(BinaryData binaryData) {
        this.ensureRoom((int)(binaryData.length(null) * 8L + 2L));
        this.write(39);
        String string = StringConverter.byteArrayToBitString(binaryData.getBytes(), (int)binaryData.bitLength(null));
        this.writeBytes(string);
        this.write(39);
    }

    @Override
    protected void writeUUID(BinaryData binaryData) {
        this.ensureRoom(40);
        this.write(39);
        this.count += StringConverter.writeUUIDHexBytes(this.getBuffer(), this.count, binaryData.getBytes());
        this.write(39);
    }

    @Override
    protected void writeBinary(BinaryData binaryData) {
        this.ensureRoom((int)(binaryData.length(null) * 2L + 2L));
        this.write(39);
        this.count += StringConverter.writeHexBytes(this.getBuffer(), this.count, binaryData.getBytes());
        this.write(39);
    }

    @Override
    protected void writeClob(ClobData clobData, Type type) {
        this.writeBytes(Long.toString(clobData.getId()));
    }

    @Override
    protected void writeBlob(BlobData blobData, Type type) {
        this.writeBytes(Long.toString(blobData.getId()));
    }

    @Override
    protected void writeArray(Object[] objectArray, Type type) {
        type = type.collectionBaseType();
        this.noSeparators = true;
        this.write(BYTES_ARRAY);
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                this.write(44);
            }
            this.writeData(objectArray[i], type);
        }
        this.write(93);
        this.noSeparators = false;
    }

    @Override
    public void writeType(int n) {
    }

    @Override
    public void writeSize(int n) {
    }

    @Override
    public int getSize(Row row) {
        return 0;
    }

    @Override
    public int getStorageSize(int n) {
        return n;
    }

    @Override
    protected void writeInteger(Number number) {
        this.writeBytes(number.toString());
    }

    @Override
    protected void writeBigint(Number number) {
        this.writeBytes(number.toString());
    }

    @Override
    protected void writeNull(Type type) {
        if (!this.noSeparators) {
            if (this.logMode == 1) {
                this.write(BYTES_IS);
            } else if (this.isWritten) {
                this.write(44);
            }
            this.isWritten = true;
        }
        this.write(BYTES_NULL);
    }

    @Override
    protected void writeOther(JavaObjectData javaObjectData) {
        this.ensureRoom(javaObjectData.getBytesLength() * 2 + 2);
        this.write(39);
        StringConverter.writeHexBytes(this.getBuffer(), this.count, javaObjectData.getBytes());
        this.count += javaObjectData.getBytesLength() * 2;
        this.write(39);
    }

    @Override
    public void writeString(String string) {
        StringConverter.stringToUnicodeBytes(this, string, false);
    }

    @Override
    protected void writeBoolean(Boolean bl) {
        this.write(bl != false ? BYTES_TRUE : BYTES_FALSE);
    }

    @Override
    protected void writeDecimal(BigDecimal bigDecimal, Type type) {
        this.writeBytes(type.convertToSQLString(bigDecimal));
    }

    @Override
    protected void writeFieldType(Type type) {
        if (!this.noSeparators) {
            if (this.logMode == 1) {
                this.write(61);
            } else if (this.isWritten) {
                this.write(44);
            }
            this.isWritten = true;
        }
    }

    @Override
    public void writeLong(long l) {
        this.writeBytes(Long.toString(l));
    }

    @Override
    protected void writeTime(TimeData timeData, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(timeData));
        this.write(39);
    }

    @Override
    protected void writeDate(TimestampData timestampData, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(timestampData));
        this.write(39);
    }

    @Override
    protected void writeTimestamp(TimestampData timestampData, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(timestampData));
        this.write(39);
    }

    @Override
    protected void writeYearMonthInterval(IntervalMonthData intervalMonthData, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(intervalMonthData));
        this.write(39);
    }

    @Override
    protected void writeDaySecondInterval(IntervalSecondData intervalSecondData, Type type) {
        this.write(39);
        this.writeBytes(type.convertToString(intervalSecondData));
        this.write(39);
    }

    @Override
    public void writeShort(int n) {
        this.writeBytes(Integer.toString(n));
    }

    @Override
    public void writeInt(int n) {
        this.writeBytes(Integer.toString(n));
    }

    @Override
    public void reset() {
        super.reset();
        this.isWritten = false;
    }

    @Override
    public RowOutputInterface duplicate() {
        throw Error.runtimeError(201, "RowOutputText");
    }

    static {
        try {
            BYTES_NULL = "NULL".getBytes("ISO-8859-1");
            BYTES_TRUE = "TRUE".getBytes("ISO-8859-1");
            BYTES_FALSE = "FALSE".getBytes("ISO-8859-1");
            BYTES_AND = " AND ".getBytes("ISO-8859-1");
            BYTES_IS = " IS ".getBytes("ISO-8859-1");
            BYTES_ARRAY = " ARRAY[".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Error.runtimeError(201, "RowOutputTextLog");
        }
    }
}

