/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.jboss.jandex;

import java.util.ArrayDeque;

public final class DotName
implements Comparable<DotName> {
    static final DotName JAVA_NAME = new DotName(null, "java", true, false);
    static final DotName JAVA_LANG_NAME = new DotName(JAVA_NAME, "lang", true, false);
    static final DotName OBJECT_NAME = new DotName(JAVA_LANG_NAME, "Object", true, false);
    private final DotName prefix;
    private final String local;
    private int hash;
    private boolean componentized = false;
    private boolean innerClass = false;

    public static DotName createSimple(String name) {
        return new DotName(null, name, false, false);
    }

    public static DotName createComponentized(DotName prefix, String localName) {
        if (localName.indexOf(46) != -1) {
            throw new IllegalArgumentException("A componentized DotName can not contain '.' characters in a local name");
        }
        return new DotName(prefix, localName, true, false);
    }

    public static DotName createComponentized(DotName prefix, String localName, boolean innerClass) {
        if (localName.indexOf(46) != -1) {
            throw new IllegalArgumentException("A componentized DotName can not contain '.' characters in a local name");
        }
        return new DotName(prefix, localName, true, innerClass);
    }

    DotName(DotName prefix, String local, boolean noDots, boolean innerClass) {
        if (local == null) {
            throw new IllegalArgumentException("Local string can not be null");
        }
        if (prefix != null && !prefix.componentized) {
            throw new IllegalArgumentException("A componentized DotName must have a componentized prefix, or null");
        }
        this.prefix = prefix;
        this.local = local;
        this.componentized = noDots;
        this.innerClass = innerClass;
    }

    public DotName prefix() {
        return this.prefix;
    }

    public String local() {
        return this.local;
    }

    public boolean isComponentized() {
        return this.componentized;
    }

    public boolean isInner() {
        return this.innerClass;
    }

    public String toString() {
        return this.toString('.');
    }

    public String toString(char delim) {
        String string = this.local;
        if (this.prefix != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.prefix.toString(delim)).append(this.innerClass ? (char)'$' : (char)delim).append(string);
            string = builder.toString();
        }
        return string;
    }

    public int hashCode() {
        int hash = this.hash;
        if (hash != 0) {
            return hash;
        }
        if (this.prefix != null) {
            hash = this.prefix.hashCode() * 31 + (this.innerClass ? 36 : 46);
            for (int i = 0; i < this.local.length(); ++i) {
                hash = 31 * hash + this.local.charAt(i);
            }
        } else {
            hash = this.local.hashCode();
        }
        this.hash = hash;
        return this.hash;
    }

    @Override
    public int compareTo(DotName other) {
        if (this.componentized && other.componentized) {
            DotName curr;
            ArrayDeque<DotName> thisStack = new ArrayDeque<DotName>();
            ArrayDeque<DotName> otherStack = new ArrayDeque<DotName>();
            for (curr = this; curr != null; curr = curr.prefix()) {
                thisStack.push(curr);
            }
            for (curr = other; curr != null; curr = curr.prefix()) {
                otherStack.push(curr);
            }
            int thisSize = thisStack.size();
            int otherSize = otherStack.size();
            int stop = Math.min(thisSize, otherSize);
            for (int i = 0; i < stop; ++i) {
                DotName thisComp = (DotName)thisStack.pop();
                DotName otherComp = (DotName)otherStack.pop();
                int comp = thisComp.local.compareTo(otherComp.local);
                if (comp == 0) continue;
                return comp;
            }
            int diff = thisSize - otherSize;
            if (diff != 0) {
                return diff;
            }
        }
        return this.toString().compareTo(other.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DotName)) {
            return false;
        }
        DotName other = (DotName)o;
        if (other.prefix == null && this.prefix == null) {
            return this.local.equals(other.local) && this.innerClass == other.innerClass;
        }
        if (!other.componentized && this.componentized) {
            return this.toString().equals(other.local);
        }
        if (other.componentized && !this.componentized) {
            return other.toString().equals(this.local);
        }
        return this.prefix != null && this.innerClass == other.innerClass && this.local.equals(other.local) && this.prefix.equals(other.prefix);
    }
}

