/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.creation.bytebuddy;

import java.lang.reflect.Modifier;
import org.evosuite.shaded.org.mockito.creation.instance.InstantiationException;
import org.evosuite.shaded.org.mockito.creation.instance.Instantiator;
import org.evosuite.shaded.org.mockito.exceptions.base.MockitoException;
import org.evosuite.shaded.org.mockito.internal.configuration.plugins.Plugins;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.ClassCreatingMockMaker;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.MockAccess;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.SubclassBytecodeGenerator;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.SubclassInjectionLoader;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.SubclassLoader;
import org.evosuite.shaded.org.mockito.internal.creation.bytebuddy.TypeCachingBytecodeGenerator;
import org.evosuite.shaded.org.mockito.internal.util.Platform;
import org.evosuite.shaded.org.mockito.internal.util.StringUtil;
import org.evosuite.shaded.org.mockito.invocation.MockHandler;
import org.evosuite.shaded.org.mockito.mock.MockCreationSettings;
import org.evosuite.shaded.org.mockito.plugins.MockMaker;

public class SubclassByteBuddyMockMaker
implements ClassCreatingMockMaker {
    private final BytecodeGenerator cachingMockBytecodeGenerator;

    public SubclassByteBuddyMockMaker() {
        this(new SubclassInjectionLoader());
    }

    public SubclassByteBuddyMockMaker(SubclassLoader loader) {
        this.cachingMockBytecodeGenerator = new TypeCachingBytecodeGenerator(new SubclassBytecodeGenerator(loader), false);
    }

    @Override
    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        Class<T> mockedProxyType = this.createMockType(settings);
        Instantiator instantiator = Plugins.getInstantiatorProvider().getInstantiator(settings);
        T mockInstance = null;
        try {
            mockInstance = instantiator.newInstance(mockedProxyType);
            MockAccess mockAccess = (MockAccess)mockInstance;
            mockAccess.setMockitoInterceptor(new MockMethodInterceptor(handler, settings));
            return SubclassByteBuddyMockMaker.ensureMockIsAssignableToMockedType(settings, mockInstance);
        }
        catch (ClassCastException cce) {
            throw new MockitoException(StringUtil.join("ClassCastException occurred while creating the mockito mock :", "  class to mock : " + SubclassByteBuddyMockMaker.describeClass(settings.getTypeToMock()), "  created class : " + SubclassByteBuddyMockMaker.describeClass(mockedProxyType), "  proxy instance class : " + SubclassByteBuddyMockMaker.describeClass(mockInstance), "  instance creation by : " + instantiator.getClass().getSimpleName(), "", "You might experience classloading issues, please ask the mockito mailing-list.", ""), cce);
        }
        catch (InstantiationException e) {
            throw new MockitoException("Unable to create mock instance of type '" + mockedProxyType.getSuperclass().getSimpleName() + "'", e);
        }
    }

    @Override
    public <T> Class<? extends T> createMockType(MockCreationSettings<T> settings) {
        try {
            return this.cachingMockBytecodeGenerator.mockClass(MockFeatures.withMockFeatures(settings.getTypeToMock(), settings.getExtraInterfaces(), settings.getSerializableMode(), settings.isStripAnnotations()));
        }
        catch (Exception bytecodeGenerationFailed) {
            throw this.prettifyFailure(settings, bytecodeGenerationFailed);
        }
    }

    private static <T> T ensureMockIsAssignableToMockedType(MockCreationSettings<T> settings, T mock) {
        Class<T> typeToMock = settings.getTypeToMock();
        return typeToMock.cast(mock);
    }

    private <T> RuntimeException prettifyFailure(MockCreationSettings<T> mockFeatures, Exception generationFailed) {
        if (mockFeatures.getTypeToMock().isArray()) {
            throw new MockitoException(StringUtil.join("Mockito cannot mock arrays: " + mockFeatures.getTypeToMock() + ".", ""), generationFailed);
        }
        if (Modifier.isPrivate(mockFeatures.getTypeToMock().getModifiers())) {
            throw new MockitoException(StringUtil.join("Mockito cannot mock this class: " + mockFeatures.getTypeToMock() + ".", "Most likely it is due to mocking a private class that is not visible to Mockito", ""), generationFailed);
        }
        throw new MockitoException(StringUtil.join("Mockito cannot mock this class: " + mockFeatures.getTypeToMock() + ".", "", "Mockito can only mock non-private & non-final classes.", "If you're not sure why you're getting this error, please report to the mailing list.", "", Platform.warnForVM("IBM J9 VM", "Early IBM virtual machine are known to have issues with Mockito, please upgrade to an up-to-date version.\n", "Hotspot", Platform.isJava8BelowUpdate45() ? "Java 8 early builds have bugs that were addressed in Java 1.8.0_45, please update your JDK!\n" : ""), Platform.describe(), "", "Underlying exception : " + generationFailed), generationFailed);
    }

    private static String describeClass(Class<?> type) {
        return type == null ? "null" : "'" + type.getCanonicalName() + "', loaded by classloader : '" + type.getClassLoader() + "'";
    }

    private static String describeClass(Object instance) {
        return instance == null ? "null" : SubclassByteBuddyMockMaker.describeClass(instance.getClass());
    }

    @Override
    public MockHandler getHandler(Object mock) {
        if (!(mock instanceof MockAccess)) {
            return null;
        }
        return ((MockAccess)mock).getMockitoInterceptor().getMockHandler();
    }

    @Override
    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        ((MockAccess)mock).setMockitoInterceptor(new MockMethodInterceptor(newHandler, settings));
    }

    @Override
    public MockMaker.TypeMockability isTypeMockable(final Class<?> type) {
        return new MockMaker.TypeMockability(){

            @Override
            public boolean mockable() {
                return !type.isPrimitive() && !Modifier.isFinal(type.getModifiers());
            }

            @Override
            public String nonMockableReason() {
                if (this.mockable()) {
                    return "";
                }
                if (type.isPrimitive()) {
                    return "primitive type";
                }
                if (Modifier.isFinal(type.getModifiers())) {
                    return "final class";
                }
                return StringUtil.join("not handled type");
            }
        };
    }
}

