/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.junit;

import org.evosuite.shaded.org.mockito.exceptions.verification.ArgumentsAreDifferent;

public class ExceptionFactory {
    private static final boolean hasJUnit = ExceptionFactory.canLoadJunitClass();

    private ExceptionFactory() {
    }

    public static AssertionError createArgumentsAreDifferentException(String message, String wanted, String actual) {
        if (hasJUnit) {
            return ExceptionFactory.createJUnitArgumentsAreDifferent(message, wanted, actual);
        }
        return new ArgumentsAreDifferent(message);
    }

    private static AssertionError createJUnitArgumentsAreDifferent(String message, String wanted, String actual) {
        return JUnitArgsAreDifferent.create(message, wanted, actual);
    }

    private static boolean canLoadJunitClass() {
        try {
            JUnitArgsAreDifferent.create("message", "wanted", "actual");
        }
        catch (NoClassDefFoundError onlyIfJUnitIsNotAvailable) {
            return false;
        }
        return true;
    }

    private static class JUnitArgsAreDifferent {
        private JUnitArgsAreDifferent() {
        }

        static AssertionError create(String message, String wanted, String actual) {
            return new org.evosuite.shaded.org.mockito.exceptions.verification.junit.ArgumentsAreDifferent(message, wanted, actual);
        }
    }
}

