/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.junit;

import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.shaded.org.mockito.MockitoSession;
import org.evosuite.shaded.org.mockito.internal.session.MockitoSessionLoggerAdapter;
import org.evosuite.shaded.org.mockito.internal.util.MockitoLogger;
import org.evosuite.shaded.org.mockito.junit.MockitoRule;
import org.evosuite.shaded.org.mockito.quality.Strictness;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class JUnitRule
implements MockitoRule {
    private final MockitoLogger logger;
    private Strictness strictness;
    private MockitoSession session;

    public JUnitRule(MockitoLogger logger2, Strictness strictness) {
        this.logger = logger2;
        this.strictness = strictness;
    }

    public Statement apply(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                JUnitRule.this.session = Mockito.mockitoSession().name(target.getClass().getSimpleName() + "." + method.getName()).strictness(JUnitRule.this.strictness).logger(new MockitoSessionLoggerAdapter(JUnitRule.this.logger)).initMocks(target).startMocking();
                Throwable testFailure = this.evaluateSafely(base);
                JUnitRule.this.session.finishMocking(testFailure);
                if (testFailure != null) {
                    throw testFailure;
                }
            }

            private Throwable evaluateSafely(Statement base2) {
                try {
                    base2.evaluate();
                    return null;
                }
                catch (Throwable throwable) {
                    return throwable;
                }
            }
        };
    }

    @Override
    public MockitoRule silent() {
        return this.strictness(Strictness.LENIENT);
    }

    @Override
    public MockitoRule strictness(Strictness strictness) {
        this.strictness = strictness;
        if (this.session != null) {
            this.session.setStrictness(strictness);
        }
        return this;
    }
}

