/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.junit;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.evosuite.shaded.org.mockito.internal.creation.settings.CreationSettings;
import org.evosuite.shaded.org.mockito.internal.junit.ArgMismatchFinder;
import org.evosuite.shaded.org.mockito.internal.junit.DefaultStubbingLookupListener;
import org.evosuite.shaded.org.mockito.internal.junit.MockitoTestListener;
import org.evosuite.shaded.org.mockito.internal.junit.TestFinishedEvent;
import org.evosuite.shaded.org.mockito.internal.junit.UnusedStubbings;
import org.evosuite.shaded.org.mockito.internal.junit.UnusedStubbingsFinder;
import org.evosuite.shaded.org.mockito.internal.util.MockitoLogger;
import org.evosuite.shaded.org.mockito.mock.MockCreationSettings;
import org.evosuite.shaded.org.mockito.quality.Strictness;

public class UniversalTestListener
implements MockitoTestListener {
    private Strictness currentStrictness;
    private final MockitoLogger logger;
    private Map<Object, MockCreationSettings> mocks = new IdentityHashMap<Object, MockCreationSettings>();
    private DefaultStubbingLookupListener stubbingLookupListener;

    public UniversalTestListener(Strictness initialStrictness, MockitoLogger logger2) {
        this.currentStrictness = initialStrictness;
        this.logger = logger2;
        this.stubbingLookupListener = new DefaultStubbingLookupListener(this.currentStrictness);
    }

    @Override
    public void testFinished(TestFinishedEvent event) {
        Set<Object> createdMocks = this.mocks.keySet();
        this.mocks = new IdentityHashMap<Object, MockCreationSettings>();
        switch (this.currentStrictness) {
            case WARN: {
                UniversalTestListener.emitWarnings(this.logger, event, createdMocks);
                break;
            }
            case STRICT_STUBS: {
                this.reportUnusedStubs(event, createdMocks);
                break;
            }
            case LENIENT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown strictness: " + (Object)((Object)this.currentStrictness));
            }
        }
    }

    private void reportUnusedStubs(TestFinishedEvent event, Collection<Object> mocks) {
        if (event.getFailure() == null && !this.stubbingLookupListener.isMismatchesReported()) {
            UnusedStubbings unused = new UnusedStubbingsFinder().getUnusedStubbings(mocks);
            unused.reportUnused();
        }
    }

    private static void emitWarnings(MockitoLogger logger2, TestFinishedEvent event, Collection<Object> mocks) {
        if (event.getFailure() != null) {
            new ArgMismatchFinder().getStubbingArgMismatches(mocks).format(event.getTestName(), logger2);
        } else {
            new UnusedStubbingsFinder().getUnusedStubbings(mocks).format(event.getTestName(), logger2);
        }
    }

    @Override
    public void onMockCreated(Object mock, MockCreationSettings settings) {
        this.mocks.put(mock, settings);
        ((CreationSettings)settings).getStubbingLookupListeners().add(this.stubbingLookupListener);
    }

    public void setStrictness(Strictness strictness) {
        this.currentStrictness = strictness;
        this.stubbingLookupListener.setCurrentStrictness(strictness);
    }
}

