/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.junit;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.shaded.org.mockito.internal.exceptions.Reporter;
import org.evosuite.shaded.org.mockito.internal.junit.UnusedStubbingsFinder;
import org.evosuite.shaded.org.mockito.invocation.Invocation;
import org.evosuite.shaded.org.mockito.listeners.MockCreationListener;
import org.evosuite.shaded.org.mockito.mock.MockCreationSettings;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class UnnecessaryStubbingsReporter
implements MockCreationListener {
    private List<Object> mocks = new LinkedList<Object>();

    public void validateUnusedStubs(Class<?> testClass, RunNotifier notifier) {
        Collection<Invocation> unused = new UnusedStubbingsFinder().getUnusedStubbingsByLocation(this.mocks);
        if (unused.isEmpty()) {
            return;
        }
        Description unnecessaryStubbings = Description.createTestDescription(testClass, (String)"unnecessary Mockito stubbings");
        notifier.fireTestFailure(new Failure(unnecessaryStubbings, (Throwable)Reporter.formatUnncessaryStubbingException(testClass, unused)));
    }

    @Override
    public void onMockCreated(Object mock, MockCreationSettings settings) {
        this.mocks.add(mock);
    }
}

