/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.junit;

import org.evosuite.shaded.org.mockito.exceptions.base.MockitoAssertionError;
import org.evosuite.shaded.org.mockito.internal.progress.MockingProgressImpl;
import org.evosuite.shaded.org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.evosuite.shaded.org.mockito.internal.verification.api.VerificationData;
import org.evosuite.shaded.org.mockito.junit.VerificationCollector;
import org.evosuite.shaded.org.mockito.verification.VerificationMode;
import org.evosuite.shaded.org.mockito.verification.VerificationStrategy;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class VerificationCollectorImpl
implements VerificationCollector {
    private StringBuilder builder;
    private int numberOfFailures;

    public VerificationCollectorImpl() {
        this.resetBuilder();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    VerificationCollectorImpl.this.assertLazily();
                    base.evaluate();
                    VerificationCollectorImpl.this.collectAndReport();
                }
                finally {
                    ThreadSafeMockingProgress.mockingProgress().setVerificationStrategy(MockingProgressImpl.getDefaultVerificationStrategy());
                }
            }
        };
    }

    @Override
    public void collectAndReport() throws MockitoAssertionError {
        ThreadSafeMockingProgress.mockingProgress().setVerificationStrategy(MockingProgressImpl.getDefaultVerificationStrategy());
        if (this.numberOfFailures > 0) {
            String error = this.builder.toString();
            this.resetBuilder();
            throw new MockitoAssertionError(error);
        }
    }

    @Override
    public VerificationCollector assertLazily() {
        ThreadSafeMockingProgress.mockingProgress().setVerificationStrategy(new VerificationStrategy(){

            @Override
            public VerificationMode maybeVerifyLazily(VerificationMode mode) {
                return new VerificationWrapper(mode);
            }
        });
        return this;
    }

    private void resetBuilder() {
        this.builder = new StringBuilder().append("There were multiple verification failures:");
        this.numberOfFailures = 0;
    }

    private void append(String message) {
        ++this.numberOfFailures;
        this.builder.append('\n').append(this.numberOfFailures).append(". ").append(message.substring(1, message.length()));
    }

    private class VerificationWrapper
    implements VerificationMode {
        private final VerificationMode delegate;

        private VerificationWrapper(VerificationMode delegate) {
            this.delegate = delegate;
        }

        @Override
        public void verify(VerificationData data) {
            try {
                this.delegate.verify(data);
            }
            catch (MockitoAssertionError error) {
                VerificationCollectorImpl.this.append(error.getMessage());
            }
        }

        @Override
        public VerificationMode description(String description) {
            throw new IllegalStateException("Should not fail in this mode");
        }
    }
}

