/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.runners;

import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.shaded.org.mockito.MockitoAnnotations;
import org.evosuite.shaded.org.mockito.internal.junit.DefaultTestFinishedEvent;
import org.evosuite.shaded.org.mockito.internal.junit.MockitoTestListener;
import org.evosuite.shaded.org.mockito.internal.runners.InternalRunner;
import org.evosuite.shaded.org.mockito.internal.util.Supplier;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class DefaultInternalRunner
implements InternalRunner {
    private final BlockJUnit4ClassRunner runner;

    public DefaultInternalRunner(Class<?> testClass, final Supplier<MockitoTestListener> listenerSupplier) throws InitializationError {
        this.runner = new BlockJUnit4ClassRunner(testClass){
            public Object target;
            private MockitoTestListener mockitoTestListener;

            protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
                this.target = target;
                this.mockitoTestListener = (MockitoTestListener)listenerSupplier.get();
                Mockito.framework().addListener(this.mockitoTestListener);
                MockitoAnnotations.initMocks(target);
                return super.withBefores(method, target, statement);
            }

            public void run(final RunNotifier notifier) {
                RunListener listener = new RunListener(){
                    private boolean started;
                    Throwable failure;

                    public void testStarted(Description description) throws Exception {
                        this.started = true;
                    }

                    public void testFailure(Failure failure) throws Exception {
                        this.failure = failure.getException();
                        if (!this.started && mockitoTestListener != null) {
                            Mockito.framework().removeListener(mockitoTestListener);
                        }
                    }

                    public void testFinished(Description description) throws Exception {
                        try {
                            if (mockitoTestListener != null) {
                                Mockito.framework().removeListener(mockitoTestListener);
                                mockitoTestListener.testFinished(new DefaultTestFinishedEvent(target, description.getMethodName(), this.failure));
                            }
                            Mockito.validateMockitoUsage();
                        }
                        catch (Throwable t) {
                            notifier.fireTestFailure(new Failure(description, t));
                        }
                    }
                };
                notifier.addListener(listener);
                super.run(notifier);
            }
        };
    }

    @Override
    public void run(RunNotifier notifier) {
        this.runner.run(notifier);
    }

    @Override
    public Description getDescription() {
        return this.runner.getDescription();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.runner.filter(filter);
    }
}

