/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.stubbing;

import java.util.LinkedList;
import java.util.List;
import org.evosuite.shaded.org.mockito.internal.exceptions.Reporter;
import org.evosuite.shaded.org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.evosuite.shaded.org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.evosuite.shaded.org.mockito.internal.stubbing.answers.DoesNothing;
import org.evosuite.shaded.org.mockito.internal.stubbing.answers.Returns;
import org.evosuite.shaded.org.mockito.internal.stubbing.answers.ThrowsException;
import org.evosuite.shaded.org.mockito.internal.util.MockUtil;
import org.evosuite.shaded.org.mockito.stubbing.Answer;
import org.evosuite.shaded.org.mockito.stubbing.Stubber;
import org.evosuite.shaded.org.objenesis.ObjenesisHelper;

public class StubberImpl
implements Stubber {
    private final List<Answer<?>> answers = new LinkedList();

    @Override
    public <T> T when(T mock) {
        if (mock == null) {
            throw Reporter.nullPassedToWhenMethod();
        }
        if (!MockUtil.isMock(mock)) {
            throw Reporter.notAMockPassedToWhenMethod();
        }
        MockUtil.getInvocationContainer(mock).setAnswersForStubbing(this.answers);
        return mock;
    }

    @Override
    public Stubber doReturn(Object toBeReturned) {
        return this.doReturnValues(toBeReturned);
    }

    @Override
    public Stubber doReturn(Object toBeReturned, Object ... nextToBeReturned) {
        return this.doReturnValues(toBeReturned).doReturnValues(nextToBeReturned);
    }

    private StubberImpl doReturnValues(Object ... toBeReturned) {
        if (toBeReturned == null) {
            this.answers.add(new Returns(null));
            return this;
        }
        for (Object r : toBeReturned) {
            this.answers.add(new Returns(r));
        }
        return this;
    }

    @Override
    public Stubber doThrow(Throwable ... toBeThrown) {
        if (toBeThrown == null) {
            this.answers.add(new ThrowsException(null));
            return this;
        }
        for (Throwable throwable : toBeThrown) {
            this.answers.add(new ThrowsException(throwable));
        }
        return this;
    }

    @Override
    public Stubber doThrow(Class<? extends Throwable> toBeThrown) {
        Throwable e;
        if (toBeThrown == null) {
            ThreadSafeMockingProgress.mockingProgress().reset();
            throw Reporter.notAnException();
        }
        try {
            e = ObjenesisHelper.newInstance(toBeThrown);
        }
        catch (RuntimeException instanciationError) {
            ThreadSafeMockingProgress.mockingProgress().reset();
            throw instanciationError;
        }
        return this.doThrow(e);
    }

    @Override
    public Stubber doThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable> ... nextToBeThrown) {
        Stubber stubber = this.doThrow(toBeThrown);
        if (nextToBeThrown == null) {
            ThreadSafeMockingProgress.mockingProgress().reset();
            throw Reporter.notAnException();
        }
        for (Class<? extends Throwable> next : nextToBeThrown) {
            stubber = stubber.doThrow(next);
        }
        return stubber;
    }

    @Override
    public Stubber doNothing() {
        this.answers.add(DoesNothing.doesNothing());
        return this;
    }

    @Override
    public Stubber doAnswer(Answer answer) {
        this.answers.add(answer);
        return this;
    }

    @Override
    public Stubber doCallRealMethod() {
        this.answers.add(new CallsRealMethods());
        return this;
    }
}

